/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class BlockVine
extends Block {
    public static final MapCodec<BlockVine> CODEC = BlockVine.simpleCodec(BlockVine::new);
    public static final BlockStateBoolean UP = BlockSprawling.UP;
    public static final BlockStateBoolean NORTH = BlockSprawling.NORTH;
    public static final BlockStateBoolean EAST = BlockSprawling.EAST;
    public static final BlockStateBoolean SOUTH = BlockSprawling.SOUTH;
    public static final BlockStateBoolean WEST = BlockSprawling.WEST;
    public static final Map<EnumDirection, BlockStateBoolean> PROPERTY_BY_DIRECTION = BlockSprawling.PROPERTY_BY_DIRECTION.entrySet().stream().filter(var0 -> var0.getKey() != EnumDirection.DOWN).collect(SystemUtils.toMap());
    private final Function<IBlockData, VoxelShape> shapes;

    public MapCodec<BlockVine> codec() {
        return CODEC;
    }

    public BlockVine(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(UP, false)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false));
        this.shapes = this.makeShapes();
    }

    private Function<IBlockData, VoxelShape> makeShapes() {
        Map<EnumDirection, VoxelShape> var0 = VoxelShapes.rotateAll(Block.boxZ(16.0, 0.0, 1.0));
        return this.getShapeForEachState(var1 -> {
            VoxelShape var2 = VoxelShapes.empty();
            for (Map.Entry<EnumDirection, BlockStateBoolean> var4 : PROPERTY_BY_DIRECTION.entrySet()) {
                if (!((Boolean)var1.getValue(var4.getValue())).booleanValue()) continue;
                var2 = VoxelShapes.or(var2, (VoxelShape)var0.get(var4.getKey()));
            }
            return var2.isEmpty() ? VoxelShapes.block() : var2;
        });
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapes.apply(var0);
    }

    @Override
    protected boolean propagatesSkylightDown(IBlockData var0) {
        return true;
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return this.hasFaces(this.getUpdatedState(var0, var1, var2));
    }

    private boolean hasFaces(IBlockData var0) {
        return this.countFaces(var0) > 0;
    }

    private int countFaces(IBlockData var0) {
        int var1 = 0;
        for (BlockStateBoolean var3 : PROPERTY_BY_DIRECTION.values()) {
            if (!var0.getValue(var3).booleanValue()) continue;
            ++var1;
        }
        return var1;
    }

    private boolean canSupportAtFace(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
        if (var2 == EnumDirection.DOWN) {
            return false;
        }
        BlockPosition var3 = var1.relative(var2);
        if (BlockVine.isAcceptableNeighbour(var0, var3, var2)) {
            return true;
        }
        if (var2.getAxis() != EnumDirection.EnumAxis.Y) {
            BlockStateBoolean var4 = PROPERTY_BY_DIRECTION.get(var2);
            IBlockData var5 = var0.getBlockState(var1.above());
            return var5.is(this) && var5.getValue(var4) != false;
        }
        return false;
    }

    public static boolean isAcceptableNeighbour(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
        return MultifaceBlock.canAttachTo(var0, var2, var1, var0.getBlockState(var1));
    }

    private IBlockData getUpdatedState(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        BlockPosition var3 = var2.above();
        if (var0.getValue(UP).booleanValue()) {
            var0 = (IBlockData)var0.setValue(UP, BlockVine.isAcceptableNeighbour(var1, var3, EnumDirection.DOWN));
        }
        BlockBase.BlockData var4 = null;
        for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockStateBoolean var7 = BlockVine.getPropertyForFace(var6);
            if (!var0.getValue(var7).booleanValue()) continue;
            boolean var8 = this.canSupportAtFace(var1, var2, var6);
            if (!var8) {
                if (var4 == null) {
                    var4 = var1.getBlockState(var3);
                }
                var8 = var4.is(this) && var4.getValue(var7) != false;
            }
            var0 = (IBlockData)var0.setValue(var7, var8);
        }
        return var0;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4 == EnumDirection.DOWN) {
            return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
        }
        IBlockData var8 = this.getUpdatedState(var0, var1, var3);
        if (!this.hasFaces(var8)) {
            return Blocks.AIR.defaultBlockState();
        }
        return var8;
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        IBlockData var9;
        IBlockData var8;
        BlockPosition var6;
        IBlockData var7;
        if (!var1.getGameRules().get(GameRules.SPREAD_VINES).booleanValue()) {
            return;
        }
        if (var3.nextInt(4) != 0) {
            return;
        }
        EnumDirection var4 = EnumDirection.getRandom(var3);
        BlockPosition var5 = var2.above();
        if (var4.getAxis().isHorizontal() && !var0.getValue(BlockVine.getPropertyForFace(var4)).booleanValue()) {
            if (!this.canSpread(var1, var2)) {
                return;
            }
            BlockPosition var62 = var2.relative(var4);
            IBlockData var72 = var1.getBlockState(var62);
            if (var72.isAir()) {
                EnumDirection var82 = var4.getClockWise();
                EnumDirection var92 = var4.getCounterClockWise();
                boolean var10 = var0.getValue(BlockVine.getPropertyForFace(var82));
                boolean var11 = var0.getValue(BlockVine.getPropertyForFace(var92));
                BlockPosition var12 = var62.relative(var82);
                BlockPosition var13 = var62.relative(var92);
                if (var10 && BlockVine.isAcceptableNeighbour(var1, var12, var82)) {
                    var1.setBlock(var62, (IBlockData)this.defaultBlockState().setValue(BlockVine.getPropertyForFace(var82), true), 2);
                } else if (var11 && BlockVine.isAcceptableNeighbour(var1, var13, var92)) {
                    var1.setBlock(var62, (IBlockData)this.defaultBlockState().setValue(BlockVine.getPropertyForFace(var92), true), 2);
                } else {
                    EnumDirection var14 = var4.getOpposite();
                    if (var10 && var1.isEmptyBlock(var12) && BlockVine.isAcceptableNeighbour(var1, var2.relative(var82), var14)) {
                        var1.setBlock(var12, (IBlockData)this.defaultBlockState().setValue(BlockVine.getPropertyForFace(var14), true), 2);
                    } else if (var11 && var1.isEmptyBlock(var13) && BlockVine.isAcceptableNeighbour(var1, var2.relative(var92), var14)) {
                        var1.setBlock(var13, (IBlockData)this.defaultBlockState().setValue(BlockVine.getPropertyForFace(var14), true), 2);
                    } else if ((double)var3.nextFloat() < 0.05 && BlockVine.isAcceptableNeighbour(var1, var62.above(), EnumDirection.UP)) {
                        var1.setBlock(var62, (IBlockData)this.defaultBlockState().setValue(UP, true), 2);
                    }
                }
            } else if (BlockVine.isAcceptableNeighbour(var1, var62, var4)) {
                var1.setBlock(var2, (IBlockData)var0.setValue(BlockVine.getPropertyForFace(var4), true), 2);
            }
            return;
        }
        if (var4 == EnumDirection.UP && var2.getY() < var1.getMaxY()) {
            if (this.canSupportAtFace(var1, var2, var4)) {
                var1.setBlock(var2, (IBlockData)var0.setValue(UP, true), 2);
                return;
            }
            if (var1.isEmptyBlock(var5)) {
                if (!this.canSpread(var1, var2)) {
                    return;
                }
                IBlockData var63 = var0;
                for (EnumDirection var83 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                    if (!var3.nextBoolean() && BlockVine.isAcceptableNeighbour(var1, var5.relative(var83), var83)) continue;
                    var63 = (IBlockData)var63.setValue(BlockVine.getPropertyForFace(var83), false);
                }
                if (this.hasHorizontalConnection(var63)) {
                    var1.setBlock(var5, var63, 2);
                }
                return;
            }
        }
        if (var2.getY() > var1.getMinY() && ((var7 = var1.getBlockState(var6 = var2.below())).isAir() || var7.is(this)) && (var8 = var7.isAir() ? this.defaultBlockState() : var7) != (var9 = this.copyRandomFaces(var0, var8, var3)) && this.hasHorizontalConnection(var9)) {
            var1.setBlock(var6, var9, 2);
        }
    }

    private IBlockData copyRandomFaces(IBlockData var0, IBlockData var1, RandomSource var2) {
        for (EnumDirection var4 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockStateBoolean var5;
            if (!var2.nextBoolean() || !var0.getValue(var5 = BlockVine.getPropertyForFace(var4)).booleanValue()) continue;
            var1 = (IBlockData)var1.setValue(var5, true);
        }
        return var1;
    }

    private boolean hasHorizontalConnection(IBlockData var0) {
        return var0.getValue(NORTH) != false || var0.getValue(EAST) != false || var0.getValue(SOUTH) != false || var0.getValue(WEST) != false;
    }

    private boolean canSpread(IBlockAccess var0, BlockPosition var1) {
        int var2 = 4;
        Iterable<BlockPosition> var3 = BlockPosition.betweenClosed(var1.getX() - 4, var1.getY() - 1, var1.getZ() - 4, var1.getX() + 4, var1.getY() + 1, var1.getZ() + 4);
        int var4 = 5;
        for (BlockPosition var6 : var3) {
            if (!var0.getBlockState(var6).is(this) || --var4 > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        IBlockData var2 = var1.getLevel().getBlockState(var1.getClickedPos());
        if (var2.is(this)) {
            return this.countFaces(var2) < PROPERTY_BY_DIRECTION.size();
        }
        return super.canBeReplaced(var0, var1);
    }

    @Override
    public @Nullable IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = var0.getLevel().getBlockState(var0.getClickedPos());
        boolean var2 = var1.is(this);
        IBlockData var3 = var2 ? var1 : this.defaultBlockState();
        for (EnumDirection var7 : var0.getNearestLookingDirections()) {
            boolean var9;
            if (var7 == EnumDirection.DOWN) continue;
            BlockStateBoolean var8 = BlockVine.getPropertyForFace(var7);
            boolean bl = var9 = var2 && var1.getValue(var8) != false;
            if (var9 || !this.canSupportAtFace(var0.getLevel(), var0.getClickedPos(), var7)) continue;
            return (IBlockData)var3.setValue(var8, true);
        }
        return var2 ? var3 : null;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(UP, NORTH, EAST, SOUTH, WEST);
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(EAST, var0.getValue(WEST))).setValue(SOUTH, var0.getValue(NORTH))).setValue(WEST, var0.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(EAST))).setValue(EAST, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(WEST))).setValue(WEST, var0.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(WEST))).setValue(EAST, var0.getValue(NORTH))).setValue(SOUTH, var0.getValue(EAST))).setValue(WEST, var0.getValue(SOUTH));
            }
        }
        return var0;
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        switch (var1) {
            case LEFT_RIGHT: {
                return (IBlockData)((IBlockData)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (IBlockData)((IBlockData)var0.setValue(EAST, var0.getValue(WEST))).setValue(WEST, var0.getValue(EAST));
            }
        }
        return super.mirror(var0, var1);
    }

    public static BlockStateBoolean getPropertyForFace(EnumDirection var0) {
        return PROPERTY_BY_DIRECTION.get(var0);
    }
}

