/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockWetSponge
extends Block {
    public static final MapCodec<BlockWetSponge> CODEC = BlockWetSponge.simpleCodec(BlockWetSponge::new);

    public MapCodec<BlockWetSponge> codec() {
        return CODEC;
    }

    protected BlockWetSponge(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var1.environmentAttributes().getValue(EnvironmentAttributes.WATER_EVAPORATES, var2).booleanValue()) {
            var1.setBlock(var2, Blocks.SPONGE.defaultBlockState(), 3);
            var1.levelEvent(2009, var2, 0);
            var1.playSound(null, var2, SoundEffects.WET_SPONGE_DRIES, SoundCategory.BLOCKS, 1.0f, (1.0f + var1.getRandom().nextFloat() * 0.2f) * 0.7f);
        }
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        EnumDirection var4 = EnumDirection.getRandom(var3);
        if (var4 == EnumDirection.UP) {
            return;
        }
        BlockPosition var5 = var2.relative(var4);
        IBlockData var6 = var1.getBlockState(var5);
        if (var0.canOcclude() && var6.isFaceSturdy(var1, var5, var4.getOpposite())) {
            return;
        }
        double var7 = var2.getX();
        double var9 = var2.getY();
        double var11 = var2.getZ();
        if (var4 == EnumDirection.DOWN) {
            var9 -= 0.05;
            var7 += var3.nextDouble();
            var11 += var3.nextDouble();
        } else {
            var9 += var3.nextDouble() * 0.8;
            if (var4.getAxis() == EnumDirection.EnumAxis.X) {
                var11 += var3.nextDouble();
                var7 = var4 == EnumDirection.EAST ? (var7 += 1.1) : (var7 += 0.05);
            } else {
                var7 += var3.nextDouble();
                var11 = var4 == EnumDirection.SOUTH ? (var11 += 1.1) : (var11 += 0.05);
            }
        }
        var1.addParticle(Particles.DRIPPING_WATER, var7, var9, var11, 0.0, 0.0, 0.0);
    }
}

