/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;

public class BonemealableFeaturePlacerBlock
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<BonemealableFeaturePlacerBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)ResourceKey.codec(Registries.CONFIGURED_FEATURE).fieldOf("feature").forGetter(var0 -> var0.feature), BonemealableFeaturePlacerBlock.propertiesCodec()).apply((Applicative)var02, BonemealableFeaturePlacerBlock::new));
    private final ResourceKey<WorldGenFeatureConfigured<?, ?>> feature;

    public MapCodec<BonemealableFeaturePlacerBlock> codec() {
        return CODEC;
    }

    public BonemealableFeaturePlacerBlock(ResourceKey<WorldGenFeatureConfigured<?, ?>> var0, BlockBase.Info var1) {
        super(var1);
        this.feature = var0;
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return var0.getBlockState(var1.above()).isAir();
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var02, RandomSource var1, BlockPosition var2, IBlockData var32) {
        var02.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(var0 -> var0.get(this.feature)).ifPresent(var3 -> ((WorldGenFeatureConfigured)var3.value()).place(var02, var02.getChunkSource().getGenerator(), var1, var2.above()));
    }

    @Override
    public IBlockFragilePlantElement.a getType() {
        return IBlockFragilePlantElement.a.NEIGHBOR_SPREADER;
    }
}

