/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface CaveVines {
    public static final VoxelShape SHAPE = Block.column(14.0, 0.0, 16.0);
    public static final BlockStateBoolean BERRIES = BlockProperties.BERRIES;

    public static EnumInteractionResult use(Entity var0, IBlockData var12, World var22, BlockPosition var3) {
        if (var12.getValue(BERRIES).booleanValue()) {
            if (var22 instanceof WorldServer) {
                WorldServer var4 = (WorldServer)var22;
                Block.dropFromBlockInteractLootTable(var4, LootTables.HARVEST_CAVE_VINE, var12, var22.getBlockEntity(var3), null, var0, (var1, var2) -> Block.popResource((World)var1, var3, var2));
                float var5 = MathHelper.randomBetween(var4.random, 0.8f, 1.2f);
                var4.playSound(null, var3, SoundEffects.CAVE_VINES_PICK_BERRIES, SoundCategory.BLOCKS, 1.0f, var5);
                IBlockData var6 = (IBlockData)var12.setValue(BERRIES, false);
                var4.setBlock(var3, var6, 2);
                var4.gameEvent(GameEvent.BLOCK_CHANGE, var3, GameEvent.a.of(var0, var6));
            }
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    public static boolean hasGlowBerries(IBlockData var0) {
        return var0.hasProperty(BERRIES) && var0.getValue(BERRIES) != false;
    }

    public static ToIntFunction<IBlockData> emission(int var0) {
        return var1 -> var1.getValue(BlockProperties.BERRIES) != false ? var0 : 0;
    }
}

