/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreadeableBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class GlowLichenBlock
extends MultifaceSpreadeableBlock
implements IBlockFragilePlantElement {
    public static final MapCodec<GlowLichenBlock> CODEC = GlowLichenBlock.simpleCodec(GlowLichenBlock::new);
    private final MultifaceSpreader spreader = new MultifaceSpreader(this);

    public MapCodec<GlowLichenBlock> codec() {
        return CODEC;
    }

    public GlowLichenBlock(BlockBase.Info var0) {
        super(var0);
    }

    public static ToIntFunction<IBlockData> emission(int var0) {
        return var1 -> MultifaceBlock.hasAnyFace(var1) ? var0 : 0;
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return EnumDirection.stream().anyMatch(var3 -> this.spreader.canSpreadInAnyDirection(var2, var0, var1, var3.getOpposite()));
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        this.spreader.spreadFromRandomFaceTowardRandomDirection(var3, var0, var2, var1);
    }

    @Override
    protected boolean propagatesSkylightDown(IBlockData var0) {
        return var0.getFluidState().isEmpty();
    }

    @Override
    public MultifaceSpreader getSpreader() {
        return this.spreader;
    }
}

