/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DryVegetationBlock;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.sounds.AmbientDesertBlockSoundsPlayer;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class ShortDryGrassBlock
extends DryVegetationBlock
implements IBlockFragilePlantElement {
    public static final MapCodec<ShortDryGrassBlock> CODEC = ShortDryGrassBlock.simpleCodec(ShortDryGrassBlock::new);
    private static final VoxelShape SHAPE = Block.column(12.0, 0.0, 10.0);

    public MapCodec<ShortDryGrassBlock> codec() {
        return CODEC;
    }

    protected ShortDryGrassBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        AmbientDesertBlockSoundsPlayer.playAmbientDryGrassSounds(var1, var2, var3);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return true;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        var0.setBlockAndUpdate(var2, Blocks.TALL_DRY_GRASS.defaultBlockState());
    }
}

