/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.SideChainPart;

public interface SideChainPartBlock {
    public SideChainPart getSideChainPart(IBlockData var1);

    public IBlockData setSideChainPart(IBlockData var1, SideChainPart var2);

    public EnumDirection getFacing(IBlockData var1);

    public boolean isConnectable(IBlockData var1);

    public int getMaxChainLength();

    default public List<BlockPosition> getAllBlocksConnectedTo(GeneratorAccess var0, BlockPosition var1) {
        IBlockData var2 = var0.getBlockState(var1);
        if (!this.isConnectable(var2)) {
            return List.of();
        }
        c var3 = this.getNeighbors(var0, var1, this.getFacing(var2));
        LinkedList<BlockPosition> var4 = new LinkedList<BlockPosition>();
        var4.add(var1);
        this.addBlocksConnectingTowards(var3::left, SideChainPart.LEFT, var4::addFirst);
        this.addBlocksConnectingTowards(var3::right, SideChainPart.RIGHT, var4::addLast);
        return var4;
    }

    private void addBlocksConnectingTowards(IntFunction<b> var0, SideChainPart var1, Consumer<BlockPosition> var2) {
        for (int var3 = 1; var3 < this.getMaxChainLength(); ++var3) {
            b var4 = var0.apply(var3);
            if (var4.connectsTowards(var1)) {
                var2.accept(var4.pos());
            }
            if (var4.isUnconnectableOrChainEnd()) break;
        }
    }

    default public void updateNeighborsAfterPoweringDown(GeneratorAccess var0, BlockPosition var1, IBlockData var2) {
        c var3 = this.getNeighbors(var0, var1, this.getFacing(var2));
        var3.left().disconnectFromRight();
        var3.right().disconnectFromLeft();
    }

    default public void updateSelfAndNeighborsOnPoweringUp(GeneratorAccess var0, BlockPosition var1, IBlockData var2, IBlockData var3) {
        if (!this.isConnectable(var2)) {
            return;
        }
        if (this.isBeingUpdatedByNeighbor(var2, var3)) {
            return;
        }
        c var4 = this.getNeighbors(var0, var1, this.getFacing(var2));
        SideChainPart var5 = SideChainPart.UNCONNECTED;
        int var6 = var4.left().isConnectable() ? this.getAllBlocksConnectedTo(var0, var4.left().pos()).size() : 0;
        int var7 = var4.right().isConnectable() ? this.getAllBlocksConnectedTo(var0, var4.right().pos()).size() : 0;
        int var8 = 1;
        if (this.canConnect(var6, var8)) {
            var5 = var5.whenConnectedToTheLeft();
            var4.left().connectToTheRight();
            var8 += var6;
        }
        if (this.canConnect(var7, var8)) {
            var5 = var5.whenConnectedToTheRight();
            var4.right().connectToTheLeft();
        }
        this.setPart(var0, var1, var5);
    }

    private boolean canConnect(int var0, int var1) {
        return var0 > 0 && var1 + var0 <= this.getMaxChainLength();
    }

    private boolean isBeingUpdatedByNeighbor(IBlockData var0, IBlockData var1) {
        boolean var2 = this.getSideChainPart(var0).isConnected();
        boolean var3 = this.isConnectable(var1) && this.getSideChainPart(var1).isConnected();
        return var2 || var3;
    }

    private c getNeighbors(GeneratorAccess var0, BlockPosition var1, EnumDirection var2) {
        return new c(this, var0, var2, var1, new HashMap<BlockPosition, b>());
    }

    default public void setPart(GeneratorAccess var0, BlockPosition var1, SideChainPart var2) {
        IBlockData var3 = var0.getBlockState(var1);
        if (this.getSideChainPart(var3) != var2) {
            var0.setBlock(var1, this.setSideChainPart(var3, var2), 3);
        }
    }

    public record c(SideChainPartBlock block, GeneratorAccess level, EnumDirection facing, BlockPosition center, Map<BlockPosition, b> cache) {
        private boolean isConnectableToThisBlock(IBlockData var0) {
            return this.block.isConnectable(var0) && this.block.getFacing(var0) == this.facing;
        }

        private b createNewNeighbor(BlockPosition var0) {
            IBlockData var1 = this.level.getBlockState(var0);
            SideChainPart var2 = this.isConnectableToThisBlock(var1) ? this.block.getSideChainPart(var1) : null;
            return var2 == null ? new a(var0) : new d(this.level, this.block, var0, var2);
        }

        private b getOrCreateNeighbor(EnumDirection var0, Integer var1) {
            return this.cache.computeIfAbsent(this.center.relative(var0, (int)var1), this::createNewNeighbor);
        }

        public b left(int var0) {
            return this.getOrCreateNeighbor(this.facing.getClockWise(), var0);
        }

        public b right(int var0) {
            return this.getOrCreateNeighbor(this.facing.getCounterClockWise(), var0);
        }

        public b left() {
            return this.left(1);
        }

        public b right() {
            return this.right(1);
        }
    }

    public static sealed interface b
    permits a, d {
        public BlockPosition pos();

        public boolean isConnectable();

        public boolean isUnconnectableOrChainEnd();

        public boolean connectsTowards(SideChainPart var1);

        default public void connectToTheRight() {
        }

        default public void connectToTheLeft() {
        }

        default public void disconnectFromRight() {
        }

        default public void disconnectFromLeft() {
        }
    }

    public record d(GeneratorAccess level, SideChainPartBlock block, BlockPosition pos, SideChainPart part) implements b
    {
        @Override
        public boolean isConnectable() {
            return true;
        }

        @Override
        public boolean isUnconnectableOrChainEnd() {
            return this.part.isChainEnd();
        }

        @Override
        public boolean connectsTowards(SideChainPart var0) {
            return this.part.isConnectionTowards(var0);
        }

        @Override
        public void connectToTheRight() {
            this.block.setPart(this.level, this.pos, this.part.whenConnectedToTheRight());
        }

        @Override
        public void connectToTheLeft() {
            this.block.setPart(this.level, this.pos, this.part.whenConnectedToTheLeft());
        }

        @Override
        public void disconnectFromRight() {
            this.block.setPart(this.level, this.pos, this.part.whenDisconnectedFromTheRight());
        }

        @Override
        public void disconnectFromLeft() {
            this.block.setPart(this.level, this.pos, this.part.whenDisconnectedFromTheLeft());
        }
    }

    public record a(BlockPosition pos) implements b
    {
        @Override
        public boolean isConnectable() {
            return false;
        }

        @Override
        public boolean isUnconnectableOrChainEnd() {
            return true;
        }

        @Override
        public boolean connectsTowards(SideChainPart var0) {
            return false;
        }
    }
}

