/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class TorchflowerCropBlock
extends BlockCrops {
    public static final MapCodec<TorchflowerCropBlock> CODEC = TorchflowerCropBlock.simpleCodec(TorchflowerCropBlock::new);
    public static final int MAX_AGE = 1;
    public static final BlockStateInteger AGE = BlockProperties.AGE_1;
    private static final VoxelShape[] SHAPES = Block.boxes(1, var0 -> Block.column(6.0, 0.0, 6 + var0 * 4));
    private static final int BONEMEAL_INCREASE = 1;

    public MapCodec<TorchflowerCropBlock> codec() {
        return CODEC;
    }

    public TorchflowerCropBlock(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES[this.getAge(var0)];
    }

    @Override
    protected BlockStateInteger getAgeProperty() {
        return AGE;
    }

    @Override
    public int getMaxAge() {
        return 2;
    }

    @Override
    protected IMaterial getBaseSeedId() {
        return Items.TORCHFLOWER_SEEDS;
    }

    @Override
    public IBlockData getStateForAge(int var0) {
        if (var0 == 2) {
            return Blocks.TORCHFLOWER.defaultBlockState();
        }
        return super.getStateForAge(var0);
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var3.nextInt(3) != 0) {
            super.randomTick(var0, var1, var2, var3);
        }
    }

    @Override
    protected int getBonemealAgeIncrease(World var0) {
        return 1;
    }
}

