/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class WallHangingSignBlock
extends BlockSign {
    public static final MapCodec<WallHangingSignBlock> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BlockPropertyWood.CODEC.fieldOf("wood_type").forGetter(BlockSign::type), WallHangingSignBlock.propertiesCodec()).apply((Applicative)var0, WallHangingSignBlock::new));
    public static final BlockStateEnum<EnumDirection> FACING = BlockFacingHorizontal.FACING;
    private static final Map<EnumDirection.EnumAxis, VoxelShape> SHAPES_PLANK = VoxelShapes.rotateHorizontalAxis(Block.column(16.0, 4.0, 14.0, 16.0));
    private static final Map<EnumDirection.EnumAxis, VoxelShape> SHAPES = VoxelShapes.rotateHorizontalAxis(VoxelShapes.or(SHAPES_PLANK.get(EnumDirection.EnumAxis.Z), Block.column(14.0, 2.0, 0.0, 10.0)));

    public MapCodec<WallHangingSignBlock> codec() {
        return CODEC;
    }

    public WallHangingSignBlock(BlockPropertyWood var0, BlockBase.Info var1) {
        super(var0, var1.sound(var0.hangingSignSoundType()));
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(WATERLOGGED, false));
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        TileEntitySign var7;
        TileEntity tileEntity = var2.getBlockEntity(var3);
        if (tileEntity instanceof TileEntitySign && this.shouldTryToChainAnotherHangingSign(var1, var4, var6, var7 = (TileEntitySign)tileEntity, var0)) {
            return EnumInteractionResult.PASS;
        }
        return super.useItemOn(var0, var1, var2, var3, var4, var5, var6);
    }

    private boolean shouldTryToChainAnotherHangingSign(IBlockData var0, EntityHuman var1, MovingObjectPositionBlock var2, TileEntitySign var3, ItemStack var4) {
        return !var3.canExecuteClickCommands(var3.isFacingFrontText(var1), var1) && var4.getItem() instanceof HangingSignItem && !this.isHittingEditableSide(var2, var0);
    }

    private boolean isHittingEditableSide(MovingObjectPositionBlock var0, IBlockData var1) {
        return var0.getDirection().getAxis() == var1.getValue(FACING).getAxis();
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES.get(var0.getValue(FACING).getAxis());
    }

    @Override
    protected VoxelShape getBlockSupportShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return this.getShape(var0, var1, var2, VoxelShapeCollision.empty());
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES_PLANK.get(var0.getValue(FACING).getAxis());
    }

    public boolean canPlace(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        EnumDirection var3 = var0.getValue(FACING).getClockWise();
        EnumDirection var4 = var0.getValue(FACING).getCounterClockWise();
        return this.canAttachTo(var1, var0, var2.relative(var3), var4) || this.canAttachTo(var1, var0, var2.relative(var4), var3);
    }

    public boolean canAttachTo(IWorldReader var0, IBlockData var1, BlockPosition var2, EnumDirection var3) {
        IBlockData var4 = var0.getBlockState(var2);
        if (var4.is(TagsBlock.WALL_HANGING_SIGNS)) {
            return var4.getValue(FACING).getAxis().test(var1.getValue(FACING));
        }
        return var4.isFaceSturdy(var0, var2, var3, EnumBlockSupport.FULL);
    }

    @Override
    public @Nullable IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = this.defaultBlockState();
        Fluid var2 = var0.getLevel().getFluidState(var0.getClickedPos());
        World var3 = var0.getLevel();
        BlockPosition var4 = var0.getClickedPos();
        for (EnumDirection var8 : var0.getNearestLookingDirections()) {
            EnumDirection var9;
            if (!var8.getAxis().isHorizontal() || var8.getAxis().test(var0.getClickedFace()) || !(var1 = (IBlockData)var1.setValue(FACING, var9 = var8.getOpposite())).canSurvive(var3, var4) || !this.canPlace(var1, var3, var4)) continue;
            return (IBlockData)var1.setValue(WATERLOGGED, var2.getType() == FluidTypes.WATER);
        }
        return null;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4.getAxis() == var0.getValue(FACING).getClockWise().getAxis() && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    public float getYRotationDegrees(IBlockData var0) {
        return var0.getValue(FACING).toYRot();
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, WATERLOGGED);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new HangingSignBlockEntity(var0, var1);
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }

    @Override
    public <T extends TileEntity> @Nullable BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        return WallHangingSignBlock.createTickerHelper(var2, TileEntityTypes.HANGING_SIGN, TileEntitySign::tick);
    }
}

