/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import org.slf4j.Logger;

public final class BannerPatternLayers
extends Record
implements TooltipProvider {
    final List<b> layers;
    static final Logger LOGGER = LogUtils.getLogger();
    public static final BannerPatternLayers EMPTY = new BannerPatternLayers(List.of());
    public static final Codec<BannerPatternLayers> CODEC = b.CODEC.listOf().xmap(BannerPatternLayers::new, BannerPatternLayers::layers);
    public static final StreamCodec<RegistryFriendlyByteBuf, BannerPatternLayers> STREAM_CODEC = b.STREAM_CODEC.apply(ByteBufCodecs.list()).map(BannerPatternLayers::new, BannerPatternLayers::layers);

    public BannerPatternLayers(List<b> var0) {
        this.layers = var0;
    }

    public BannerPatternLayers removeLast() {
        return new BannerPatternLayers(List.copyOf(this.layers.subList(0, this.layers.size() - 1)));
    }

    @Override
    public void addToTooltip(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
        for (int var4 = 0; var4 < Math.min(this.layers().size(), 6); ++var4) {
            var1.accept(this.layers().get(var4).description().withStyle(EnumChatFormat.GRAY));
        }
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{BannerPatternLayers.class, "layers", "layers"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BannerPatternLayers.class, "layers", "layers"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BannerPatternLayers.class, "layers", "layers"}, this, var0);
    }

    public List<b> layers() {
        return this.layers;
    }

    public record b(Holder<EnumBannerPatternType> pattern, EnumColor color) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)EnumBannerPatternType.CODEC.fieldOf("pattern").forGetter(b::pattern), (App)EnumColor.CODEC.fieldOf("color").forGetter(b::color)).apply((Applicative)var0, b::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, b> STREAM_CODEC = StreamCodec.composite(EnumBannerPatternType.STREAM_CODEC, b::pattern, EnumColor.STREAM_CODEC, b::color, b::new);

        public IChatMutableComponent description() {
            String var0 = this.pattern.value().translationKey();
            return IChatBaseComponent.translatable(var0 + "." + this.color.getName());
        }
    }

    public static class a {
        private final ImmutableList.Builder<b> layers = ImmutableList.builder();

        @Deprecated
        public a addIfRegistered(HolderGetter<EnumBannerPatternType> var0, ResourceKey<EnumBannerPatternType> var1, EnumColor var2) {
            Optional<Holder.c<EnumBannerPatternType>> var3 = var0.get(var1);
            if (var3.isEmpty()) {
                LOGGER.warn("Unable to find banner pattern with id: '{}'", (Object)var1.identifier());
                return this;
            }
            return this.add((Holder<EnumBannerPatternType>)var3.get(), var2);
        }

        public a add(Holder<EnumBannerPatternType> var0, EnumColor var1) {
            return this.add(new b(var0, var1));
        }

        public a add(b var0) {
            this.layers.add((Object)var0);
            return this;
        }

        public a addAll(BannerPatternLayers var0) {
            this.layers.addAll(var0.layers);
            return this;
        }

        public BannerPatternLayers build() {
            return new BannerPatternLayers((List<b>)this.layers.build());
        }
    }
}

