/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.entity.ListBackedContainer;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.slf4j.Logger;

public class ChiseledBookShelfBlockEntity
extends TileEntity
implements ListBackedContainer {
    public static final int MAX_BOOKS_IN_STORAGE = 6;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_LAST_INTERACTED_SLOT = -1;
    private final NonNullList<ItemStack> items = NonNullList.withSize(6, ItemStack.EMPTY);
    public int lastInteractedSlot = -1;

    public ChiseledBookShelfBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.CHISELED_BOOKSHELF, var0, var1);
    }

    private void updateState(int var0) {
        if (var0 < 0 || var0 >= 6) {
            LOGGER.error("Expected slot 0-5, got {}", (Object)var0);
            return;
        }
        this.lastInteractedSlot = var0;
        IBlockData var1 = this.getBlockState();
        for (int var2 = 0; var2 < ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.size(); ++var2) {
            boolean var3 = !this.getItem(var2).isEmpty();
            BlockStateBoolean var4 = ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(var2);
            var1 = (IBlockData)var1.setValue(var4, var3);
        }
        Objects.requireNonNull(this.level).setBlock(this.worldPosition, var1, 3);
        this.level.gameEvent(GameEvent.BLOCK_CHANGE, this.worldPosition, GameEvent.a.of(var1));
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.items.clear();
        ContainerUtil.loadAllItems(var0, this.items);
        this.lastInteractedSlot = var0.getIntOr("last_interacted_slot", -1);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        ContainerUtil.saveAllItems(var0, this.items, true);
        var0.putInt("last_interacted_slot", this.lastInteractedSlot);
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public boolean acceptsItemType(ItemStack var0) {
        return var0.is(TagsItem.BOOKSHELF_BOOKS);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        ItemStack var2 = Objects.requireNonNullElse(this.getItems().get(var0), ItemStack.EMPTY);
        this.getItems().set(var0, ItemStack.EMPTY);
        if (!var2.isEmpty()) {
            this.updateState(var0);
        }
        return var2;
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        if (this.acceptsItemType(var1)) {
            this.getItems().set(var0, var1);
            this.updateState(var0);
        } else if (var1.isEmpty()) {
            this.removeItem(var0, this.getMaxStackSize());
        }
    }

    @Override
    public boolean canTakeItem(IInventory var0, int var1, ItemStack var22) {
        return var0.hasAnyMatching(var2 -> {
            if (var2.isEmpty()) {
                return true;
            }
            return ItemStack.isSameItemSameComponents(var22, var2) && var2.getCount() + var22.getCount() <= var0.getMaxStackSize((ItemStack)var2);
        });
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return IInventory.stillValidBlockEntity(this, var0);
    }

    public int getLastInteractedSlot() {
        return this.lastInteractedSlot;
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        super.applyImplicitComponents(var0);
        var0.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY).copyInto(this.items);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.a var0) {
        super.collectImplicitComponents(var0);
        var0.set(DataComponents.CONTAINER, ItemContainerContents.fromItems(this.items));
    }

    @Override
    public void removeComponentsFromTag(ValueOutput var0) {
        var0.discard("Items");
    }
}

