/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerDispenser;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class TileEntityDispenser
extends TileEntityLootable {
    public static final int CONTAINER_SIZE = 9;
    private static final IChatBaseComponent DEFAULT_NAME = IChatBaseComponent.translatable("container.dispenser");
    private NonNullList<ItemStack> items = NonNullList.withSize(9, ItemStack.EMPTY);

    protected TileEntityDispenser(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2) {
        super(var0, var1, var2);
    }

    public TileEntityDispenser(BlockPosition var0, IBlockData var1) {
        this(TileEntityTypes.DISPENSER, var0, var1);
    }

    @Override
    public int getContainerSize() {
        return 9;
    }

    public int getRandomSlot(RandomSource var0) {
        this.unpackLootTable(null);
        int var1 = -1;
        int var2 = 1;
        for (int var3 = 0; var3 < this.items.size(); ++var3) {
            if (this.items.get(var3).isEmpty() || var0.nextInt(var2++) != 0) continue;
            var1 = var3;
        }
        return var1;
    }

    public ItemStack insertItem(ItemStack var0) {
        int var1 = this.getMaxStackSize(var0);
        for (int var2 = 0; var2 < this.items.size(); ++var2) {
            ItemStack var3 = this.items.get(var2);
            if (!var3.isEmpty() && !ItemStack.isSameItemSameComponents(var0, var3)) continue;
            int var4 = Math.min(var0.getCount(), var1 - var3.getCount());
            if (var4 > 0) {
                if (var3.isEmpty()) {
                    this.setItem(var2, var0.split(var4));
                } else {
                    var0.shrink(var4);
                    var3.grow(var4);
                }
            }
            if (var0.isEmpty()) break;
        }
        return var0;
    }

    @Override
    protected IChatBaseComponent getDefaultName() {
        return DEFAULT_NAME;
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        if (!this.tryLoadLootTable(var0)) {
            ContainerUtil.loadAllItems(var0, this.items);
        }
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        if (!this.trySaveLootTable(var0)) {
            ContainerUtil.saveAllItems(var0, this.items);
        }
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> var0) {
        this.items = var0;
    }

    @Override
    protected Container createMenu(int var0, PlayerInventory var1) {
        return new ContainerDispenser(var0, var1, this);
    }
}

