/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public abstract class TileEntityFurnace
extends TileEntityContainer
implements IWorldInventory,
RecipeCraftingHolder,
AutoRecipeOutput {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    private static final Codec<Map<ResourceKey<IRecipe<?>>, Integer>> RECIPES_USED_CODEC = Codec.unboundedMap(IRecipe.KEY_CODEC, (Codec)Codec.INT);
    private static final short DEFAULT_COOKING_TIMER = 0;
    private static final short DEFAULT_COOKING_TOTAL_TIME = 0;
    private static final short DEFAULT_LIT_TIME_REMAINING = 0;
    private static final short DEFAULT_LIT_TOTAL_TIME = 0;
    protected NonNullList<ItemStack> items = NonNullList.withSize(3, ItemStack.EMPTY);
    public int litTimeRemaining;
    int litTotalTime;
    public int cookingTimer;
    public int cookingTotalTime;
    protected final IContainerProperties dataAccess = new IContainerProperties(){

        @Override
        public int get(int var0) {
            switch (var0) {
                case 0: {
                    return TileEntityFurnace.this.litTimeRemaining;
                }
                case 1: {
                    return TileEntityFurnace.this.litTotalTime;
                }
                case 2: {
                    return TileEntityFurnace.this.cookingTimer;
                }
                case 3: {
                    return TileEntityFurnace.this.cookingTotalTime;
                }
            }
            return 0;
        }

        @Override
        public void set(int var0, int var1) {
            switch (var0) {
                case 0: {
                    TileEntityFurnace.this.litTimeRemaining = var1;
                    break;
                }
                case 1: {
                    TileEntityFurnace.this.litTotalTime = var1;
                    break;
                }
                case 2: {
                    TileEntityFurnace.this.cookingTimer = var1;
                    break;
                }
                case 3: {
                    TileEntityFurnace.this.cookingTotalTime = var1;
                    break;
                }
            }
        }

        @Override
        public int getCount() {
            return 4;
        }
    };
    public final Reference2IntOpenHashMap<ResourceKey<IRecipe<?>>> recipesUsed = new Reference2IntOpenHashMap();
    private final CraftingManager.a<SingleRecipeInput, ? extends RecipeCooking> quickCheck;

    protected TileEntityFurnace(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2, Recipes<? extends RecipeCooking> var3) {
        super(var0, var1, var2);
        this.quickCheck = CraftingManager.createCheck(var3);
    }

    private boolean isLit() {
        return this.litTimeRemaining > 0;
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.items = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
        ContainerUtil.loadAllItems(var0, this.items);
        this.cookingTimer = var0.getShortOr("cooking_time_spent", (short)0);
        this.cookingTotalTime = var0.getShortOr("cooking_total_time", (short)0);
        this.litTimeRemaining = var0.getShortOr("lit_time_remaining", (short)0);
        this.litTotalTime = var0.getShortOr("lit_total_time", (short)0);
        this.recipesUsed.clear();
        this.recipesUsed.putAll(var0.read("RecipesUsed", RECIPES_USED_CODEC).orElse(Map.of()));
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        var0.putShort("cooking_time_spent", (short)this.cookingTimer);
        var0.putShort("cooking_total_time", (short)this.cookingTotalTime);
        var0.putShort("lit_time_remaining", (short)this.litTimeRemaining);
        var0.putShort("lit_total_time", (short)this.litTotalTime);
        ContainerUtil.saveAllItems(var0, this.items);
        var0.store("RecipesUsed", RECIPES_USED_CODEC, this.recipesUsed);
    }

    public static void serverTick(WorldServer var0, BlockPosition var1, IBlockData var2, TileEntityFurnace var3) {
        boolean var9;
        boolean var4 = var3.isLit();
        boolean var5 = false;
        if (var3.isLit()) {
            --var3.litTimeRemaining;
        }
        ItemStack var6 = var3.items.get(1);
        ItemStack var7 = var3.items.get(0);
        boolean var8 = !var7.isEmpty();
        boolean bl = var9 = !var6.isEmpty();
        if (var3.isLit() || var9 && var8) {
            SingleRecipeInput var11 = new SingleRecipeInput(var7);
            RecipeHolder var10 = var8 ? (RecipeHolder)var3.quickCheck.getRecipeFor(var11, var0).orElse(null) : null;
            int var12 = var3.getMaxStackSize();
            if (!var3.isLit() && TileEntityFurnace.canBurn(var0.registryAccess(), var10, var11, var3.items, var12)) {
                var3.litTotalTime = var3.litTimeRemaining = var3.getBurnDuration(var0.fuelValues(), var6);
                if (var3.isLit()) {
                    var5 = true;
                    if (var9) {
                        Item var13 = var6.getItem();
                        var6.shrink(1);
                        if (var6.isEmpty()) {
                            var3.items.set(1, var13.getCraftingRemainder());
                        }
                    }
                }
            }
            if (var3.isLit() && TileEntityFurnace.canBurn(var0.registryAccess(), var10, var11, var3.items, var12)) {
                ++var3.cookingTimer;
                if (var3.cookingTimer == var3.cookingTotalTime) {
                    var3.cookingTimer = 0;
                    var3.cookingTotalTime = TileEntityFurnace.getTotalCookTime(var0, var3);
                    if (TileEntityFurnace.burn(var0.registryAccess(), var10, var11, var3.items, var12)) {
                        var3.setRecipeUsed(var10);
                    }
                    var5 = true;
                }
            } else {
                var3.cookingTimer = 0;
            }
        } else if (!var3.isLit() && var3.cookingTimer > 0) {
            var3.cookingTimer = MathHelper.clamp(var3.cookingTimer - 2, 0, var3.cookingTotalTime);
        }
        if (var4 != var3.isLit()) {
            var5 = true;
            var2 = (IBlockData)var2.setValue(BlockFurnace.LIT, var3.isLit());
            var0.setBlock(var1, var2, 3);
        }
        if (var5) {
            TileEntityFurnace.setChanged(var0, var1, var2);
        }
    }

    private static boolean canBurn(IRegistryCustom var0, @Nullable RecipeHolder<? extends RecipeCooking> var1, SingleRecipeInput var2, NonNullList<ItemStack> var3, int var4) {
        if (var3.get(0).isEmpty() || var1 == null) {
            return false;
        }
        ItemStack var5 = var1.value().assemble(var2, (HolderLookup.a)var0);
        if (var5.isEmpty()) {
            return false;
        }
        ItemStack var6 = var3.get(2);
        if (var6.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents(var6, var5)) {
            return false;
        }
        if (var6.getCount() < var4 && var6.getCount() < var6.getMaxStackSize()) {
            return true;
        }
        return var6.getCount() < var5.getMaxStackSize();
    }

    private static boolean burn(IRegistryCustom var0, @Nullable RecipeHolder<? extends RecipeCooking> var1, SingleRecipeInput var2, NonNullList<ItemStack> var3, int var4) {
        if (var1 == null || !TileEntityFurnace.canBurn(var0, var1, var2, var3, var4)) {
            return false;
        }
        ItemStack var5 = var3.get(0);
        ItemStack var6 = var1.value().assemble(var2, (HolderLookup.a)var0);
        ItemStack var7 = var3.get(2);
        if (var7.isEmpty()) {
            var3.set(2, var6.copy());
        } else if (ItemStack.isSameItemSameComponents(var7, var6)) {
            var7.grow(1);
        }
        if (var5.is(Blocks.WET_SPONGE.asItem()) && !var3.get(1).isEmpty() && var3.get(1).is(Items.BUCKET)) {
            var3.set(1, new ItemStack(Items.WATER_BUCKET));
        }
        var5.shrink(1);
        return true;
    }

    protected int getBurnDuration(FuelValues var0, ItemStack var1) {
        return var0.burnDuration(var1);
    }

    private static int getTotalCookTime(WorldServer var02, TileEntityFurnace var1) {
        SingleRecipeInput var2 = new SingleRecipeInput(var1.getItem(0));
        return var1.quickCheck.getRecipeFor(var2, var02).map(var0 -> ((RecipeCooking)var0.value()).cookingTime()).orElse(200);
    }

    @Override
    public int[] getSlotsForFace(EnumDirection var0) {
        if (var0 == EnumDirection.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        if (var0 == EnumDirection.UP) {
            return SLOTS_FOR_UP;
        }
        return SLOTS_FOR_SIDES;
    }

    @Override
    public boolean canPlaceItemThroughFace(int var0, ItemStack var1, @Nullable EnumDirection var2) {
        return this.canPlaceItem(var0, var1);
    }

    @Override
    public boolean canTakeItemThroughFace(int var0, ItemStack var1, EnumDirection var2) {
        if (var2 == EnumDirection.DOWN && var0 == 1) {
            return var1.is(Items.WATER_BUCKET) || var1.is(Items.BUCKET);
        }
        return true;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<ItemStack> var0) {
        this.items = var0;
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        World world;
        ItemStack var2 = this.items.get(var0);
        boolean var3 = !var1.isEmpty() && ItemStack.isSameItemSameComponents(var2, var1);
        this.items.set(var0, var1);
        var1.limitSize(this.getMaxStackSize(var1));
        if (var0 == 0 && !var3 && (world = this.level) instanceof WorldServer) {
            WorldServer var4 = (WorldServer)world;
            this.cookingTotalTime = TileEntityFurnace.getTotalCookTime(var4, this);
            this.cookingTimer = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean canPlaceItem(int var0, ItemStack var1) {
        if (var0 == 2) {
            return false;
        }
        if (var0 == 1) {
            ItemStack var2 = this.items.get(1);
            return this.level.fuelValues().isFuel(var1) || var1.is(Items.BUCKET) && !var2.is(Items.BUCKET);
        }
        return true;
    }

    @Override
    public void setRecipeUsed(@Nullable RecipeHolder<?> var0) {
        if (var0 != null) {
            ResourceKey<IRecipe<?>> var1 = var0.id();
            this.recipesUsed.addTo(var1, 1);
        }
    }

    @Override
    public @Nullable RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    @Override
    public void awardUsedRecipes(EntityHuman var0, List<ItemStack> var1) {
    }

    public void awardUsedRecipesAndPopExperience(EntityPlayer var0) {
        List<RecipeHolder<?>> var1 = this.getRecipesToAwardAndPopExperience(var0.level(), var0.position());
        var0.awardRecipes(var1);
        for (RecipeHolder<?> var3 : var1) {
            var0.triggerRecipeCrafted(var3, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(WorldServer var0, Vec3D var1) {
        ArrayList var2 = Lists.newArrayList();
        for (Reference2IntMap.Entry var42 : this.recipesUsed.reference2IntEntrySet()) {
            var0.recipeAccess().byKey((ResourceKey)var42.getKey()).ifPresent(var4 -> {
                var2.add(var4);
                TileEntityFurnace.createExperience(var0, var1, var42.getIntValue(), ((RecipeCooking)var4.value()).experience());
            });
        }
        return var2;
    }

    private static void createExperience(WorldServer var0, Vec3D var1, int var2, float var3) {
        int var4 = MathHelper.floor((float)var2 * var3);
        float var5 = MathHelper.frac((float)var2 * var3);
        if (var5 != 0.0f && var0.random.nextFloat() < var5) {
            ++var4;
        }
        EntityExperienceOrb.award(var0, var1, var4);
    }

    @Override
    public void fillStackedContents(StackedItemContents var0) {
        for (ItemStack var2 : this.items) {
            var0.accountStack(var2);
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPosition var0, IBlockData var1) {
        super.preRemoveSideEffects(var0, var1);
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            this.getRecipesToAwardAndPopExperience(var2, Vec3D.atCenterOf(var0));
        }
    }
}

