/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.entity.vault.VaultClientData;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.entity.vault.VaultServerData;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class VaultBlockEntity
extends TileEntity {
    private final VaultServerData serverData = new VaultServerData();
    private final VaultSharedData sharedData = new VaultSharedData();
    private final VaultClientData clientData = new VaultClientData();
    private VaultConfig config = VaultConfig.DEFAULT;

    public VaultBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.VAULT, var0, var1);
    }

    @Override
    public @Nullable Packet<PacketListenerPlayOut> getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return SystemUtils.make(new NBTTagCompound(), var1 -> var1.store("shared_data", VaultSharedData.CODEC, var0.createSerializationContext(DynamicOpsNBT.INSTANCE), this.sharedData));
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        var0.store("config", VaultConfig.CODEC, this.config);
        var0.store("shared_data", VaultSharedData.CODEC, this.sharedData);
        var0.store("server_data", VaultServerData.CODEC, this.serverData);
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        var0.read("server_data", VaultServerData.CODEC).ifPresent(this.serverData::set);
        this.config = var0.read("config", VaultConfig.CODEC).orElse(VaultConfig.DEFAULT);
        var0.read("shared_data", VaultSharedData.CODEC).ifPresent(this.sharedData::set);
    }

    public @Nullable VaultServerData getServerData() {
        return this.level == null || this.level.isClientSide() ? null : this.serverData;
    }

    public VaultSharedData getSharedData() {
        return this.sharedData;
    }

    public VaultClientData getClientData() {
        return this.clientData;
    }

    public VaultConfig getConfig() {
        return this.config;
    }

    @VisibleForTesting
    public void setConfig(VaultConfig var0) {
        this.config = var0;
    }

    public static final class a {
        private static final int PARTICLE_TICK_RATE = 20;
        private static final float IDLE_PARTICLE_CHANCE = 0.5f;
        private static final float AMBIENT_SOUND_CHANCE = 0.02f;
        private static final int ACTIVATION_PARTICLE_COUNT = 20;
        private static final int DEACTIVATION_PARTICLE_COUNT = 20;

        public static void tick(World var0, BlockPosition var1, IBlockData var2, VaultClientData var3, VaultSharedData var4) {
            var3.updateDisplayItemSpin();
            if (var0.getGameTime() % 20L == 0L) {
                a.emitConnectionParticlesForNearbyPlayers(var0, var1, var2, var4);
            }
            a.emitIdleParticles(var0, var1, var4, var2.getValue(VaultBlock.OMINOUS) != false ? Particles.SOUL_FIRE_FLAME : Particles.SMALL_FLAME);
            a.playIdleSounds(var0, var1, var4);
        }

        public static void emitActivationParticles(World var0, BlockPosition var1, IBlockData var2, VaultSharedData var3, ParticleParam var4) {
            a.emitConnectionParticlesForNearbyPlayers(var0, var1, var2, var3);
            RandomSource var5 = var0.random;
            for (int var6 = 0; var6 < 20; ++var6) {
                Vec3D var7 = a.randomPosInsideCage(var1, var5);
                var0.addParticle(Particles.SMOKE, var7.x(), var7.y(), var7.z(), 0.0, 0.0, 0.0);
                var0.addParticle(var4, var7.x(), var7.y(), var7.z(), 0.0, 0.0, 0.0);
            }
        }

        public static void emitDeactivationParticles(World var0, BlockPosition var1, ParticleParam var2) {
            RandomSource var3 = var0.random;
            for (int var4 = 0; var4 < 20; ++var4) {
                Vec3D var5 = a.randomPosCenterOfCage(var1, var3);
                Vec3D var6 = new Vec3D(var3.nextGaussian() * 0.02, var3.nextGaussian() * 0.02, var3.nextGaussian() * 0.02);
                var0.addParticle(var2, var5.x(), var5.y(), var5.z(), var6.x(), var6.y(), var6.z());
            }
        }

        private static void emitIdleParticles(World var0, BlockPosition var1, VaultSharedData var2, ParticleParam var3) {
            RandomSource var4 = var0.getRandom();
            if (var4.nextFloat() <= 0.5f) {
                Vec3D var5 = a.randomPosInsideCage(var1, var4);
                var0.addParticle(Particles.SMOKE, var5.x(), var5.y(), var5.z(), 0.0, 0.0, 0.0);
                if (a.shouldDisplayActiveEffects(var2)) {
                    var0.addParticle(var3, var5.x(), var5.y(), var5.z(), 0.0, 0.0, 0.0);
                }
            }
        }

        private static void emitConnectionParticlesForPlayer(World var0, Vec3D var1, EntityHuman var2) {
            RandomSource var3 = var0.random;
            Vec3D var4 = var1.vectorTo(var2.position().add(0.0, var2.getBbHeight() / 2.0f, 0.0));
            int var5 = MathHelper.nextInt(var3, 2, 5);
            for (int var6 = 0; var6 < var5; ++var6) {
                Vec3D var7 = var4.offsetRandom(var3, 1.0f);
                var0.addParticle(Particles.VAULT_CONNECTION, var1.x(), var1.y(), var1.z(), var7.x(), var7.y(), var7.z());
            }
        }

        private static void emitConnectionParticlesForNearbyPlayers(World var0, BlockPosition var1, IBlockData var2, VaultSharedData var3) {
            Set<UUID> var4 = var3.getConnectedPlayers();
            if (var4.isEmpty()) {
                return;
            }
            Vec3D var5 = a.keyholePos(var1, var2.getValue(VaultBlock.FACING));
            for (UUID var7 : var4) {
                EntityHuman var8 = var0.getPlayerByUUID(var7);
                if (var8 == null || !a.isWithinConnectionRange(var1, var3, var8)) continue;
                a.emitConnectionParticlesForPlayer(var0, var5, var8);
            }
        }

        private static boolean isWithinConnectionRange(BlockPosition var0, VaultSharedData var1, EntityHuman var2) {
            return var2.blockPosition().distSqr(var0) <= MathHelper.square(var1.connectedParticlesRange());
        }

        private static void playIdleSounds(World var0, BlockPosition var1, VaultSharedData var2) {
            if (!a.shouldDisplayActiveEffects(var2)) {
                return;
            }
            RandomSource var3 = var0.getRandom();
            if (var3.nextFloat() <= 0.02f) {
                var0.playLocalSound(var1, SoundEffects.VAULT_AMBIENT, SoundCategory.BLOCKS, var3.nextFloat() * 0.25f + 0.75f, var3.nextFloat() + 0.5f, false);
            }
        }

        public static boolean shouldDisplayActiveEffects(VaultSharedData var0) {
            return var0.hasDisplayItem();
        }

        private static Vec3D randomPosCenterOfCage(BlockPosition var0, RandomSource var1) {
            return Vec3D.atLowerCornerOf(var0).add(MathHelper.nextDouble(var1, 0.4, 0.6), MathHelper.nextDouble(var1, 0.4, 0.6), MathHelper.nextDouble(var1, 0.4, 0.6));
        }

        private static Vec3D randomPosInsideCage(BlockPosition var0, RandomSource var1) {
            return Vec3D.atLowerCornerOf(var0).add(MathHelper.nextDouble(var1, 0.1, 0.9), MathHelper.nextDouble(var1, 0.25, 0.75), MathHelper.nextDouble(var1, 0.1, 0.9));
        }

        private static Vec3D keyholePos(BlockPosition var0, EnumDirection var1) {
            return Vec3D.atBottomCenterOf(var0).add((double)var1.getStepX() * 0.5, 1.75, (double)var1.getStepZ() * 0.5);
        }
    }

    public static final class b {
        private static final int UNLOCKING_DELAY_TICKS = 14;
        private static final int DISPLAY_CYCLE_TICK_RATE = 20;
        private static final int INSERT_FAIL_SOUND_BUFFER_TICKS = 15;

        public static void tick(WorldServer var0, BlockPosition var1, IBlockData var2, VaultConfig var3, VaultServerData var4, VaultSharedData var5) {
            VaultState var6 = var2.getValue(VaultBlock.STATE);
            if (b.shouldCycleDisplayItem(var0.getGameTime(), var6)) {
                b.cycleDisplayItemFromLootTable(var0, var6, var3, var5, var1);
            }
            IBlockData var7 = var2;
            if (var0.getGameTime() >= var4.stateUpdatingResumesAt() && var2 != (var7 = (IBlockData)var7.setValue(VaultBlock.STATE, var6.tickAndGetNext(var0, var1, var3, var4, var5)))) {
                b.setVaultState(var0, var1, var2, var7, var3, var5);
            }
            if (var4.isDirty || var5.isDirty) {
                VaultBlockEntity.setChanged(var0, var1, var2);
                if (var5.isDirty) {
                    var0.sendBlockUpdated(var1, var2, var7, 2);
                }
                var4.isDirty = false;
                var5.isDirty = false;
            }
        }

        public static void tryInsertKey(WorldServer var0, BlockPosition var1, IBlockData var2, VaultConfig var3, VaultServerData var4, VaultSharedData var5, EntityHuman var6, ItemStack var7) {
            VaultState var8 = var2.getValue(VaultBlock.STATE);
            if (!b.canEjectReward(var3, var8)) {
                return;
            }
            if (!b.isValidToInsert(var3, var7)) {
                b.playInsertFailSound(var0, var4, var1, SoundEffects.VAULT_INSERT_ITEM_FAIL);
                return;
            }
            if (var4.hasRewardedPlayer(var6)) {
                b.playInsertFailSound(var0, var4, var1, SoundEffects.VAULT_REJECT_REWARDED_PLAYER);
                return;
            }
            List<ItemStack> var9 = b.resolveItemsToEject(var0, var3, var1, var6, var7);
            if (var9.isEmpty()) {
                return;
            }
            var6.awardStat(StatisticList.ITEM_USED.get(var7.getItem()));
            var7.consume(var3.keyItem().getCount(), var6);
            b.unlock(var0, var2, var1, var3, var4, var5, var9);
            var4.addToRewardedPlayers(var6);
            var5.updateConnectedPlayersWithinRange(var0, var1, var4, var3, var3.deactivationRange());
        }

        static void setVaultState(WorldServer var0, BlockPosition var1, IBlockData var2, IBlockData var3, VaultConfig var4, VaultSharedData var5) {
            VaultState var6 = var2.getValue(VaultBlock.STATE);
            VaultState var7 = var3.getValue(VaultBlock.STATE);
            var0.setBlock(var1, var3, 3);
            var6.onTransition(var0, var1, var7, var4, var5, var3.getValue(VaultBlock.OMINOUS));
        }

        static void cycleDisplayItemFromLootTable(WorldServer var0, VaultState var1, VaultConfig var2, VaultSharedData var3, BlockPosition var4) {
            if (!b.canEjectReward(var2, var1)) {
                var3.setDisplayItem(ItemStack.EMPTY);
                return;
            }
            ItemStack var5 = b.getRandomDisplayItemFromLootTable(var0, var4, var2.overrideLootTableToDisplay().orElse(var2.lootTable()));
            var3.setDisplayItem(var5);
        }

        private static ItemStack getRandomDisplayItemFromLootTable(WorldServer var0, BlockPosition var1, ResourceKey<LootTable> var2) {
            LootParams var4;
            LootTable var3 = var0.getServer().reloadableRegistries().getLootTable(var2);
            ObjectArrayList<ItemStack> var5 = var3.getRandomItems(var4 = new LootParams.a(var0).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(var1)).create(LootContextParameterSets.VAULT), var0.getRandom());
            if (var5.isEmpty()) {
                return ItemStack.EMPTY;
            }
            return SystemUtils.getRandom(var5, var0.getRandom());
        }

        private static void unlock(WorldServer var0, IBlockData var1, BlockPosition var2, VaultConfig var3, VaultServerData var4, VaultSharedData var5, List<ItemStack> var6) {
            var4.setItemsToEject(var6);
            var5.setDisplayItem(var4.getNextItemToEject());
            var4.pauseStateUpdatingUntil(var0.getGameTime() + 14L);
            b.setVaultState(var0, var2, var1, (IBlockData)var1.setValue(VaultBlock.STATE, VaultState.UNLOCKING), var3, var5);
        }

        private static List<ItemStack> resolveItemsToEject(WorldServer var0, VaultConfig var1, BlockPosition var2, EntityHuman var3, ItemStack var4) {
            LootTable var5 = var0.getServer().reloadableRegistries().getLootTable(var1.lootTable());
            LootParams var6 = new LootParams.a(var0).withParameter(LootContextParameters.ORIGIN, Vec3D.atCenterOf(var2)).withLuck(var3.getLuck()).withParameter(LootContextParameters.THIS_ENTITY, var3).withParameter(LootContextParameters.TOOL, var4).create(LootContextParameterSets.VAULT);
            return var5.getRandomItems(var6);
        }

        private static boolean canEjectReward(VaultConfig var0, VaultState var1) {
            return !var0.keyItem().isEmpty() && var1 != VaultState.INACTIVE;
        }

        private static boolean isValidToInsert(VaultConfig var0, ItemStack var1) {
            return ItemStack.isSameItemSameComponents(var1, var0.keyItem()) && var1.getCount() >= var0.keyItem().getCount();
        }

        private static boolean shouldCycleDisplayItem(long var0, VaultState var2) {
            return var0 % 20L == 0L && var2 == VaultState.ACTIVE;
        }

        private static void playInsertFailSound(WorldServer var0, VaultServerData var1, BlockPosition var2, SoundEffect var3) {
            if (var0.getGameTime() >= var1.getLastInsertFailTimestamp() + 15L) {
                var0.playSound(null, var2, var3, SoundCategory.BLOCKS);
                var1.setLastInsertFailTimestamp(var0.getGameTime());
            }
        }
    }
}

