/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.border;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class WorldBorder
extends PersistentBase {
    public static final double MAX_SIZE = 5.9999968E7;
    public static final double MAX_CENTER_COORDINATE = 2.9999984E7;
    public static final Codec<WorldBorder> CODEC = c.CODEC.xmap(WorldBorder::new, c::new);
    public static final SavedDataType<WorldBorder> TYPE = new SavedDataType<WorldBorder>("world_border", WorldBorder::new, CODEC, DataFixTypes.SAVED_DATA_WORLD_BORDER);
    private final c settings;
    private boolean initialized;
    private final List<IWorldBorderListener> listeners = Lists.newArrayList();
    double damagePerBlock = 0.2;
    double safeZone = 5.0;
    int warningTime = 15;
    int warningBlocks = 5;
    double centerX;
    double centerZ;
    int absoluteMaxSize = 29999984;
    a extent = new d(5.9999968E7);

    public WorldBorder() {
        this(c.DEFAULT);
    }

    public WorldBorder(c var0) {
        this.settings = var0;
    }

    public boolean isWithinBounds(BlockPosition var0) {
        return this.isWithinBounds(var0.getX(), var0.getZ());
    }

    public boolean isWithinBounds(Vec3D var0) {
        return this.isWithinBounds(var0.x, var0.z);
    }

    public boolean isWithinBounds(ChunkCoordIntPair var0) {
        return this.isWithinBounds(var0.getMinBlockX(), var0.getMinBlockZ()) && this.isWithinBounds(var0.getMaxBlockX(), var0.getMaxBlockZ());
    }

    public boolean isWithinBounds(AxisAlignedBB var0) {
        return this.isWithinBounds(var0.minX, var0.minZ, var0.maxX - (double)1.0E-5f, var0.maxZ - (double)1.0E-5f);
    }

    private boolean isWithinBounds(double var0, double var2, double var4, double var6) {
        return this.isWithinBounds(var0, var2) && this.isWithinBounds(var4, var6);
    }

    public boolean isWithinBounds(double var0, double var2) {
        return this.isWithinBounds(var0, var2, 0.0);
    }

    public boolean isWithinBounds(double var0, double var2, double var4) {
        return var0 >= this.getMinX() - var4 && var0 < this.getMaxX() + var4 && var2 >= this.getMinZ() - var4 && var2 < this.getMaxZ() + var4;
    }

    public BlockPosition clampToBounds(BlockPosition var0) {
        return this.clampToBounds(var0.getX(), var0.getY(), var0.getZ());
    }

    public BlockPosition clampToBounds(Vec3D var0) {
        return this.clampToBounds(var0.x(), var0.y(), var0.z());
    }

    public BlockPosition clampToBounds(double var0, double var2, double var4) {
        return BlockPosition.containing(this.clampVec3ToBound(var0, var2, var4));
    }

    public Vec3D clampVec3ToBound(Vec3D var0) {
        return this.clampVec3ToBound(var0.x, var0.y, var0.z);
    }

    public Vec3D clampVec3ToBound(double var0, double var2, double var4) {
        return new Vec3D(MathHelper.clamp(var0, this.getMinX(), this.getMaxX() - (double)1.0E-5f), var2, MathHelper.clamp(var4, this.getMinZ(), this.getMaxZ() - (double)1.0E-5f));
    }

    public double getDistanceToBorder(Entity var0) {
        return this.getDistanceToBorder(var0.getX(), var0.getZ());
    }

    public VoxelShape getCollisionShape() {
        return this.extent.getCollisionShape();
    }

    public double getDistanceToBorder(double var0, double var2) {
        double var4 = var2 - this.getMinZ();
        double var6 = this.getMaxZ() - var2;
        double var8 = var0 - this.getMinX();
        double var10 = this.getMaxX() - var0;
        double var12 = Math.min(var8, var10);
        var12 = Math.min(var12, var4);
        return Math.min(var12, var6);
    }

    public boolean isInsideCloseToBorder(Entity var0, AxisAlignedBB var1) {
        double var2 = Math.max(MathHelper.absMax(var1.getXsize(), var1.getZsize()), 1.0);
        return this.getDistanceToBorder(var0) < var2 * 2.0 && this.isWithinBounds(var0.getX(), var0.getZ(), var2);
    }

    public BorderStatus getStatus() {
        return this.extent.getStatus();
    }

    public double getMinX() {
        return this.getMinX(0.0f);
    }

    public double getMinX(float var0) {
        return this.extent.getMinX(var0);
    }

    public double getMinZ() {
        return this.getMinZ(0.0f);
    }

    public double getMinZ(float var0) {
        return this.extent.getMinZ(var0);
    }

    public double getMaxX() {
        return this.getMaxX(0.0f);
    }

    public double getMaxX(float var0) {
        return this.extent.getMaxX(var0);
    }

    public double getMaxZ() {
        return this.getMaxZ(0.0f);
    }

    public double getMaxZ(float var0) {
        return this.extent.getMaxZ(var0);
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterZ() {
        return this.centerZ;
    }

    public void setCenter(double var0, double var2) {
        this.centerX = var0;
        this.centerZ = var2;
        this.extent.onCenterChange();
        this.setDirty();
        for (IWorldBorderListener var5 : this.getListeners()) {
            var5.onSetCenter(this, var0, var2);
        }
    }

    public double getSize() {
        return this.extent.getSize();
    }

    public long getLerpTime() {
        return this.extent.getLerpTime();
    }

    public double getLerpTarget() {
        return this.extent.getLerpTarget();
    }

    public void setSize(double var0) {
        this.extent = new d(var0);
        this.setDirty();
        for (IWorldBorderListener var3 : this.getListeners()) {
            var3.onSetSize(this, var0);
        }
    }

    public void lerpSizeBetween(double var0, double var2, long var4, long var6) {
        this.extent = var0 == var2 ? new d(var2) : new b(var0, var2, var4, var6);
        this.setDirty();
        for (IWorldBorderListener var9 : this.getListeners()) {
            var9.onLerpSize(this, var0, var2, var4, var6);
        }
    }

    protected List<IWorldBorderListener> getListeners() {
        return Lists.newArrayList(this.listeners);
    }

    public void addListener(IWorldBorderListener var0) {
        this.listeners.add(var0);
    }

    public void removeListener(IWorldBorderListener var0) {
        this.listeners.remove(var0);
    }

    public void setAbsoluteMaxSize(int var0) {
        this.absoluteMaxSize = var0;
        this.extent.onAbsoluteMaxSizeChange();
    }

    public int getAbsoluteMaxSize() {
        return this.absoluteMaxSize;
    }

    public double getSafeZone() {
        return this.safeZone;
    }

    public void setSafeZone(double var0) {
        this.safeZone = var0;
        this.setDirty();
        for (IWorldBorderListener var3 : this.getListeners()) {
            var3.onSetSafeZone(this, var0);
        }
    }

    public double getDamagePerBlock() {
        return this.damagePerBlock;
    }

    public void setDamagePerBlock(double var0) {
        this.damagePerBlock = var0;
        this.setDirty();
        for (IWorldBorderListener var3 : this.getListeners()) {
            var3.onSetDamagePerBlock(this, var0);
        }
    }

    public double getLerpSpeed() {
        return this.extent.getLerpSpeed();
    }

    public int getWarningTime() {
        return this.warningTime;
    }

    public void setWarningTime(int var0) {
        this.warningTime = var0;
        this.setDirty();
        for (IWorldBorderListener var2 : this.getListeners()) {
            var2.onSetWarningTime(this, var0);
        }
    }

    public int getWarningBlocks() {
        return this.warningBlocks;
    }

    public void setWarningBlocks(int var0) {
        this.warningBlocks = var0;
        this.setDirty();
        for (IWorldBorderListener var2 : this.getListeners()) {
            var2.onSetWarningBlocks(this, var0);
        }
    }

    public void tick() {
        this.extent = this.extent.update();
    }

    public void applyInitialSettings(long var0) {
        if (!this.initialized) {
            this.setCenter(this.settings.centerX(), this.settings.centerZ());
            this.setDamagePerBlock(this.settings.damagePerBlock());
            this.setSafeZone(this.settings.safeZone());
            this.setWarningBlocks(this.settings.warningBlocks());
            this.setWarningTime(this.settings.warningTime());
            if (this.settings.lerpTime() > 0L) {
                this.lerpSizeBetween(this.settings.size(), this.settings.lerpTarget(), this.settings.lerpTime(), var0);
            } else {
                this.setSize(this.settings.size());
            }
            this.initialized = true;
        }
    }

    public record c(double centerX, double centerZ, double damagePerBlock, double safeZone, int warningBlocks, int warningTime, double size, long lerpTime, double lerpTarget) {
        public static final c DEFAULT = new c(0.0, 0.0, 0.2, 5.0, 5, 300, 5.9999968E7, 0L, 0.0);
        public static final Codec<c> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.doubleRange((double)-2.9999984E7, (double)2.9999984E7).fieldOf("center_x").forGetter(c::centerX), (App)Codec.doubleRange((double)-2.9999984E7, (double)2.9999984E7).fieldOf("center_z").forGetter(c::centerZ), (App)Codec.DOUBLE.fieldOf("damage_per_block").forGetter(c::damagePerBlock), (App)Codec.DOUBLE.fieldOf("safe_zone").forGetter(c::safeZone), (App)Codec.INT.fieldOf("warning_blocks").forGetter(c::warningBlocks), (App)Codec.INT.fieldOf("warning_time").forGetter(c::warningTime), (App)Codec.DOUBLE.fieldOf("size").forGetter(c::size), (App)Codec.LONG.fieldOf("lerp_time").forGetter(c::lerpTime), (App)Codec.DOUBLE.fieldOf("lerp_target").forGetter(c::lerpTarget)).apply((Applicative)var0, c::new));

        public c(WorldBorder var0) {
            this(var0.centerX, var0.centerZ, var0.damagePerBlock, var0.safeZone, var0.warningBlocks, var0.warningTime, var0.extent.getSize(), var0.extent.getLerpTime(), var0.extent.getLerpTarget());
        }
    }

    class d
    implements a {
        private final double size;
        private double minX;
        private double minZ;
        private double maxX;
        private double maxZ;
        private VoxelShape shape;

        public d(double var1) {
            this.size = var1;
            this.updateBox();
        }

        @Override
        public double getMinX(float var0) {
            return this.minX;
        }

        @Override
        public double getMaxX(float var0) {
            return this.maxX;
        }

        @Override
        public double getMinZ(float var0) {
            return this.minZ;
        }

        @Override
        public double getMaxZ(float var0) {
            return this.maxZ;
        }

        @Override
        public double getSize() {
            return this.size;
        }

        @Override
        public BorderStatus getStatus() {
            return BorderStatus.STATIONARY;
        }

        @Override
        public double getLerpSpeed() {
            return 0.0;
        }

        @Override
        public long getLerpTime() {
            return 0L;
        }

        @Override
        public double getLerpTarget() {
            return this.size;
        }

        private void updateBox() {
            this.minX = MathHelper.clamp(WorldBorder.this.getCenterX() - this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.minZ = MathHelper.clamp(WorldBorder.this.getCenterZ() - this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.maxX = MathHelper.clamp(WorldBorder.this.getCenterX() + this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.maxZ = MathHelper.clamp(WorldBorder.this.getCenterZ() + this.size / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
            this.shape = VoxelShapes.join(VoxelShapes.INFINITY, VoxelShapes.box(Math.floor(this.getMinX(0.0f)), Double.NEGATIVE_INFINITY, Math.floor(this.getMinZ(0.0f)), Math.ceil(this.getMaxX(0.0f)), Double.POSITIVE_INFINITY, Math.ceil(this.getMaxZ(0.0f))), OperatorBoolean.ONLY_FIRST);
        }

        @Override
        public void onAbsoluteMaxSizeChange() {
            this.updateBox();
        }

        @Override
        public void onCenterChange() {
            this.updateBox();
        }

        @Override
        public a update() {
            return this;
        }

        @Override
        public VoxelShape getCollisionShape() {
            return this.shape;
        }
    }

    static interface a {
        public double getMinX(float var1);

        public double getMaxX(float var1);

        public double getMinZ(float var1);

        public double getMaxZ(float var1);

        public double getSize();

        public double getLerpSpeed();

        public long getLerpTime();

        public double getLerpTarget();

        public BorderStatus getStatus();

        public void onAbsoluteMaxSizeChange();

        public void onCenterChange();

        public a update();

        public VoxelShape getCollisionShape();
    }

    class b
    implements a {
        private final double from;
        private final double to;
        private final long lerpEnd;
        private final long lerpBegin;
        private final double lerpDuration;
        private long lerpProgress;
        private double size;
        private double previousSize;

        b(double var1, double var3, long var5, long var7) {
            double var9;
            this.from = var1;
            this.to = var3;
            this.lerpDuration = var5;
            this.lerpProgress = var5;
            this.lerpBegin = var7;
            this.lerpEnd = this.lerpBegin + var5;
            this.size = var9 = this.calculateSize();
            this.previousSize = var9;
        }

        @Override
        public double getMinX(float var0) {
            return MathHelper.clamp(WorldBorder.this.getCenterX() - MathHelper.lerp((double)var0, this.getPreviousSize(), this.getSize()) / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getMinZ(float var0) {
            return MathHelper.clamp(WorldBorder.this.getCenterZ() - MathHelper.lerp((double)var0, this.getPreviousSize(), this.getSize()) / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getMaxX(float var0) {
            return MathHelper.clamp(WorldBorder.this.getCenterX() + MathHelper.lerp((double)var0, this.getPreviousSize(), this.getSize()) / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getMaxZ(float var0) {
            return MathHelper.clamp(WorldBorder.this.getCenterZ() + MathHelper.lerp((double)var0, this.getPreviousSize(), this.getSize()) / 2.0, (double)(-WorldBorder.this.absoluteMaxSize), (double)WorldBorder.this.absoluteMaxSize);
        }

        @Override
        public double getSize() {
            return this.size;
        }

        public double getPreviousSize() {
            return this.previousSize;
        }

        private double calculateSize() {
            double var0 = (this.lerpDuration - (double)this.lerpProgress) / this.lerpDuration;
            return var0 < 1.0 ? MathHelper.lerp(var0, this.from, this.to) : this.to;
        }

        @Override
        public double getLerpSpeed() {
            return Math.abs(this.from - this.to) / (double)(this.lerpEnd - this.lerpBegin);
        }

        @Override
        public long getLerpTime() {
            return this.lerpProgress;
        }

        @Override
        public double getLerpTarget() {
            return this.to;
        }

        @Override
        public BorderStatus getStatus() {
            return this.to < this.from ? BorderStatus.SHRINKING : BorderStatus.GROWING;
        }

        @Override
        public void onCenterChange() {
        }

        @Override
        public void onAbsoluteMaxSizeChange() {
        }

        @Override
        public a update() {
            --this.lerpProgress;
            this.previousSize = this.size;
            this.size = this.calculateSize();
            if (this.lerpProgress <= 0L) {
                WorldBorder.this.setDirty();
                return new d(this.to);
            }
            return this;
        }

        @Override
        public VoxelShape getCollisionShape() {
            return VoxelShapes.join(VoxelShapes.INFINITY, VoxelShapes.box(Math.floor(this.getMinX(0.0f)), Double.NEGATIVE_INFINITY, Math.floor(this.getMinZ(0.0f)), Math.ceil(this.getMaxX(0.0f)), Double.POSITIVE_INFINITY, Math.ceil(this.getMaxZ(0.0f))), OperatorBoolean.ONLY_FIRST);
        }
    }
}

