/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.VarInt;
import net.minecraft.world.level.chunk.DataPalette;
import net.minecraft.world.level.chunk.DataPaletteExpandable;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import org.apache.commons.lang3.Validate;

public class DataPaletteLinear<T>
implements DataPalette<T> {
    private final T[] values;
    private final int bits;
    private int size;

    private DataPaletteLinear(int var0, List<T> var1) {
        this.values = new Object[1 << var0];
        this.bits = var0;
        Validate.isTrue((var1.size() <= this.values.length ? 1 : 0) != 0, (String)"Can't initialize LinearPalette of size %d with %d entries", (Object[])new Object[]{this.values.length, var1.size()});
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            this.values[var2] = var1.get(var2);
        }
        this.size = var1.size();
    }

    private DataPaletteLinear(T[] var0, int var1, int var2) {
        this.values = var0;
        this.bits = var1;
        this.size = var2;
    }

    public static <A> DataPalette<A> create(int var0, List<A> var1) {
        return new DataPaletteLinear<A>(var0, var1);
    }

    @Override
    public int idFor(T var0, DataPaletteExpandable<T> var1) {
        int var2;
        for (var2 = 0; var2 < this.size; ++var2) {
            if (this.values[var2] != var0) continue;
            return var2;
        }
        if ((var2 = this.size++) < this.values.length) {
            this.values[var2] = var0;
            return var2;
        }
        return var1.onResize(this.bits + 1, var0);
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        for (int var1 = 0; var1 < this.size; ++var1) {
            if (!var0.test(this.values[var1])) continue;
            return true;
        }
        return false;
    }

    @Override
    public T valueFor(int var0) {
        if (var0 >= 0 && var0 < this.size) {
            return this.values[var0];
        }
        throw new MissingPaletteEntryException(var0);
    }

    @Override
    public void read(PacketDataSerializer var0, Registry<T> var1) {
        this.size = var0.readVarInt();
        for (int var2 = 0; var2 < this.size; ++var2) {
            this.values[var2] = var1.byIdOrThrow(var0.readVarInt());
        }
    }

    @Override
    public void write(PacketDataSerializer var0, Registry<T> var1) {
        var0.writeVarInt(this.size);
        for (int var2 = 0; var2 < this.size; ++var2) {
            var0.writeVarInt(var1.getId(this.values[var2]));
        }
    }

    @Override
    public int getSerializedSize(Registry<T> var0) {
        int var1 = VarInt.getByteSize(this.getSize());
        for (int var2 = 0; var2 < this.getSize(); ++var2) {
            var1 += VarInt.getByteSize(var0.getId(this.values[var2]));
        }
        return var1;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public DataPalette<T> copy() {
        return new DataPaletteLinear<Object>((Object[])this.values.clone(), this.bits, this.size);
    }
}

