/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NbtException;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import net.minecraft.world.ticks.TickListChunk;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public record SerializableChunkData(PalettedContainerFactory containerFactory, ChunkCoordIntPair chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.d blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, ChunkConverter upgradeData, long @Nullable [] carvingMask, Map<HeightMap.Type, long[]> heightmaps, IChunkAccess.b packedTicks, @Nullable ShortList[] postProcessingSections, boolean lightCorrect, List<b> sectionData, List<NBTTagCompound> entities, List<NBTTagCompound> blockEntities, NBTTagCompound structureData) {
    private static final Codec<List<TickListChunk<Block>>> BLOCK_TICKS_CODEC = TickListChunk.codec(BuiltInRegistries.BLOCK.byNameCodec()).listOf();
    private static final Codec<List<TickListChunk<FluidType>>> FLUID_TICKS_CODEC = TickListChunk.codec(BuiltInRegistries.FLUID.byNameCodec()).listOf();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG = "block_ticks";
    private static final String FLUID_TICKS_TAG = "fluid_ticks";
    public static final String X_POS_TAG = "xPos";
    public static final String Z_POS_TAG = "zPos";
    public static final String HEIGHTMAPS_TAG = "Heightmaps";
    public static final String IS_LIGHT_ON_TAG = "isLightOn";
    public static final String SECTIONS_TAG = "sections";
    public static final String BLOCK_LIGHT_TAG = "BlockLight";
    public static final String SKY_LIGHT_TAG = "SkyLight";

    public static @Nullable SerializableChunkData parse(LevelHeightAccessor var0, PalettedContainerFactory var12, NBTTagCompound var2) {
        Object var222;
        List<NBTBase> var21;
        if (var2.getString("Status").isEmpty()) {
            return null;
        }
        ChunkCoordIntPair var32 = new ChunkCoordIntPair(var2.getIntOr(X_POS_TAG, 0), var2.getIntOr(Z_POS_TAG, 0));
        long var4 = var2.getLongOr("LastUpdate", 0L);
        long var6 = var2.getLongOr("InhabitedTime", 0L);
        ChunkStatus var8 = var2.read("Status", ChunkStatus.CODEC).orElse(ChunkStatus.EMPTY);
        ChunkConverter var9 = var2.getCompound(TAG_UPGRADE_DATA).map(var1 -> new ChunkConverter((NBTTagCompound)var1, var0)).orElse(ChunkConverter.EMPTY);
        boolean var10 = var2.getBooleanOr(IS_LIGHT_ON_TAG, false);
        BlendingData.d var11 = var2.read("blending_data", BlendingData.d.CODEC).orElse(null);
        BelowZeroRetrogen var122 = var2.read("below_zero_retrogen", BelowZeroRetrogen.CODEC).orElse(null);
        long[] var13 = var2.getLongArray("carving_mask").orElse(null);
        EnumMap<HeightMap.Type, long[]> var14 = new EnumMap<HeightMap.Type, long[]>(HeightMap.Type.class);
        var2.getCompound(HEIGHTMAPS_TAG).ifPresent(var22 -> {
            for (HeightMap.Type var4 : var8.heightmapsAfter()) {
                var22.getLongArray(var4.getSerializationKey()).ifPresent(var2 -> var14.put(var4, (long[])var2));
            }
        });
        List<TickListChunk<Block>> var15 = TickListChunk.filterTickListForChunk(var2.read(BLOCK_TICKS_TAG, BLOCK_TICKS_CODEC).orElse(List.of()), var32);
        List<TickListChunk<FluidType>> var16 = TickListChunk.filterTickListForChunk(var2.read(FLUID_TICKS_TAG, FLUID_TICKS_CODEC).orElse(List.of()), var32);
        IChunkAccess.b var17 = new IChunkAccess.b(var15, var16);
        NBTTagList var18 = var2.getListOrEmpty("PostProcessing");
        @Nullable ShortList[] var19 = new ShortList[var18.size()];
        for (int var20 = 0; var20 < var18.size(); ++var20) {
            var21 = var18.getList(var20).orElse(null);
            if (var21 == null || ((NBTTagList)var21).isEmpty()) continue;
            var222 = new ShortArrayList(((NBTTagList)var21).size());
            for (int var23 = 0; var23 < ((NBTTagList)var21).size(); ++var23) {
                var222.add(((NBTTagList)var21).getShortOr(var23, (short)0));
            }
            var19[var20] = var222;
        }
        List<NBTTagCompound> var20 = var2.getList("entities").stream().flatMap(NBTTagList::compoundStream).toList();
        var21 = var2.getList("block_entities").stream().flatMap(NBTTagList::compoundStream).toList();
        var222 = var2.getCompoundOrEmpty("structures");
        NBTTagList var23 = var2.getListOrEmpty(SECTIONS_TAG);
        ArrayList<b> var24 = new ArrayList<b>(var23.size());
        Codec<PalettedContainerRO<Holder<BiomeBase>>> var25 = var12.biomeContainerCodec();
        Codec<DataPaletteBlock<IBlockData>> var26 = var12.blockStatesContainerCodec();
        for (int var27 = 0; var27 < var23.size(); ++var27) {
            ChunkSection var31;
            Object var33;
            Object var322;
            Optional<NBTTagCompound> var28 = var23.getCompound(var27);
            if (var28.isEmpty()) continue;
            NBTTagCompound var29 = var28.get();
            byte var30 = var29.getByteOr("Y", (byte)0);
            if (var30 >= var0.getMinSectionY() && var30 <= var0.getMaxSectionY()) {
                var322 = var29.getCompound("block_states").map(var3 -> (DataPaletteBlock)var26.parse((DynamicOps)DynamicOpsNBT.INSTANCE, var3).promotePartial(var2 -> SerializableChunkData.logErrors(var32, var30, var2)).getOrThrow(a::new)).orElseGet(var12::createForBlockStates);
                var33 = var29.getCompound("biomes").map(var3 -> (PalettedContainerRO)var25.parse((DynamicOps)DynamicOpsNBT.INSTANCE, var3).promotePartial(var2 -> SerializableChunkData.logErrors(var32, var30, var2)).getOrThrow(a::new)).orElseGet(var12::createForBiomes);
                var31 = new ChunkSection((DataPaletteBlock<IBlockData>)var322, (PalettedContainerRO<Holder<BiomeBase>>)var33);
            } else {
                var31 = null;
            }
            var322 = var29.getByteArray(BLOCK_LIGHT_TAG).map(NibbleArray::new).orElse(null);
            var33 = var29.getByteArray(SKY_LIGHT_TAG).map(NibbleArray::new).orElse(null);
            var24.add(new b(var30, var31, (NibbleArray)var322, (NibbleArray)var33));
        }
        return new SerializableChunkData(var12, var32, var0.getMinSectionY(), var4, var6, var8, var11, var122, var9, var13, var14, var17, var19, var10, var24, var20, var21, (NBTTagCompound)var222);
    }

    /*
     * WARNING - void declaration
     */
    public ProtoChunk read(WorldServer var0, VillagePlace var1, RegionStorageInfo var2, ChunkCoordIntPair var3) {
        void var13_16;
        Object var13;
        if (!Objects.equals(var3, this.chunkPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{var3, var3, this.chunkPos});
            var0.getServer().reportMisplacedChunk(this.chunkPos, var3, var2);
        }
        int var4 = var0.getSectionsCount();
        ChunkSection[] var5 = new ChunkSection[var4];
        boolean var6 = var0.dimensionType().hasSkyLight();
        ChunkProviderServer var7 = var0.getChunkSource();
        LevelLightEngine var8 = ((IChunkProvider)var7).getLightEngine();
        PalettedContainerFactory var9 = var0.palettedContainerFactory();
        boolean var10 = false;
        for (b b2 : this.sectionData) {
            boolean var15;
            var13 = SectionPosition.of(var3, b2.y);
            if (b2.chunkSection != null) {
                var5[var0.getSectionIndexFromSectionY((int)b2.y)] = b2.chunkSection;
                var1.checkConsistencyWithBlocks((SectionPosition)var13, b2.chunkSection);
            }
            boolean var14 = b2.blockLight != null;
            boolean bl = var15 = var6 && b2.skyLight != null;
            if (!var14 && !var15) continue;
            if (!var10) {
                var8.retainData(var3, true);
                var10 = true;
            }
            if (var14) {
                var8.queueSectionData(EnumSkyBlock.BLOCK, (SectionPosition)var13, b2.blockLight);
            }
            if (!var15) continue;
            var8.queueSectionData(EnumSkyBlock.SKY, (SectionPosition)var13, b2.skyLight);
        }
        ChunkType var11 = this.chunkStatus.getChunkType();
        if (var11 == ChunkType.LEVELCHUNK) {
            var13 = new LevelChunkTicks<Block>(this.packedTicks.blocks());
            var14 = new LevelChunkTicks(this.packedTicks.fluids());
            Chunk chunk = new Chunk(var0.getLevel(), var3, this.upgradeData, (LevelChunkTicks<Block>)var13, (LevelChunkTicks<FluidType>)var14, this.inhabitedTime, var5, SerializableChunkData.postLoadChunk(var0, this.entities, this.blockEntities), BlendingData.unpack(this.blendingData));
        } else {
            ProtoChunk var15;
            var13 = ProtoChunkTickList.load(this.packedTicks.blocks());
            var14 = ProtoChunkTickList.load(this.packedTicks.fluids());
            ProtoChunk protoChunk = var15 = new ProtoChunk(var3, this.upgradeData, var5, (ProtoChunkTickList<Block>)var13, (ProtoChunkTickList<FluidType>)var14, var0, var9, BlendingData.unpack(this.blendingData));
            protoChunk.setInhabitedTime(this.inhabitedTime);
            if (this.belowZeroRetrogen != null) {
                var15.setBelowZeroRetrogen(this.belowZeroRetrogen);
            }
            var15.setPersistedStatus(this.chunkStatus);
            if (this.chunkStatus.isOrAfter(ChunkStatus.INITIALIZE_LIGHT)) {
                var15.setLightEngine(var8);
            }
        }
        var13_16.setLightCorrect(this.lightCorrect);
        var13 = EnumSet.noneOf(HeightMap.Type.class);
        for (HeightMap.Type var15 : var13_16.getPersistedStatus().heightmapsAfter()) {
            long[] lArray = this.heightmaps.get(var15);
            if (lArray != null) {
                var13_16.setHeightmap(var15, lArray);
                continue;
            }
            ((AbstractCollection)var13).add(var15);
        }
        HeightMap.primeHeightmaps((IChunkAccess)var13_16, (Set<HeightMap.Type>)var13);
        var13_16.setAllStarts(SerializableChunkData.unpackStructureStart(StructurePieceSerializationContext.fromLevel(var0), this.structureData, var0.getSeed()));
        var13_16.setAllReferences(SerializableChunkData.unpackStructureReferences(var0.registryAccess(), var3, this.structureData));
        for (int var14 = 0; var14 < this.postProcessingSections.length; ++var14) {
            ShortList var15 = this.postProcessingSections[var14];
            if (var15 == null) continue;
            var13_16.addPackedPostProcess(var15, var14);
        }
        if (var11 == ChunkType.LEVELCHUNK) {
            return new ProtoChunkExtension((Chunk)var13_16, false);
        }
        ProtoChunk var14 = (ProtoChunk)var13_16;
        for (NBTTagCompound nBTTagCompound : this.entities) {
            var14.addEntity(nBTTagCompound);
        }
        for (NBTTagCompound nBTTagCompound : this.blockEntities) {
            var14.setBlockEntityNbt(nBTTagCompound);
        }
        if (this.carvingMask != null) {
            var14.setCarvingMask(new CarvingMask(this.carvingMask, var13_16.getMinY()));
        }
        return var14;
    }

    private static void logErrors(ChunkCoordIntPair var0, int var1, String var2) {
        LOGGER.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{var0.x, var1, var0.z, var2});
    }

    public static SerializableChunkData copyOf(WorldServer var02, IChunkAccess var1) {
        Object var12;
        Object var10;
        Object var9;
        if (!var1.canBeSerialized()) {
            throw new IllegalArgumentException("Chunk can't be serialized: " + String.valueOf(var1));
        }
        ChunkCoordIntPair var2 = var1.getPos();
        ArrayList<b> var3 = new ArrayList<b>();
        ChunkSection[] var4 = var1.getSections();
        LightEngineThreaded var5 = var02.getChunkSource().getLightEngine();
        for (int var6 = var5.getMinLightSection(); var6 < var5.getMaxLightSection(); ++var6) {
            int var7 = var1.getSectionIndexFromSectionY(var6);
            boolean var8 = var7 >= 0 && var7 < var4.length;
            var9 = var5.getLayerListener(EnumSkyBlock.BLOCK).getDataLayerData(SectionPosition.of(var2, var6));
            var10 = var5.getLayerListener(EnumSkyBlock.SKY).getDataLayerData(SectionPosition.of(var2, var6));
            NibbleArray nibbleArray = var9 != null && !((NibbleArray)var9).isEmpty() ? ((NibbleArray)var9).copy() : null;
            Object object = var12 = var10 != null && !((NibbleArray)var10).isEmpty() ? ((NibbleArray)var10).copy() : null;
            if (!var8 && nibbleArray == null && var12 == null) continue;
            ChunkSection var13 = var8 ? var4[var7].copy() : null;
            var3.add(new b(var6, var13, nibbleArray, (NibbleArray)var12));
        }
        ArrayList<NBTTagCompound> var6 = new ArrayList<NBTTagCompound>(var1.getBlockEntitiesPos().size());
        for (BlockPosition var8 : var1.getBlockEntitiesPos()) {
            var9 = var1.getBlockEntityNbtForSaving(var8, var02.registryAccess());
            if (var9 == null) continue;
            var6.add((NBTTagCompound)var9);
        }
        ArrayList var7 = new ArrayList();
        long[] var8 = null;
        if (var1.getPersistedStatus().getChunkType() == ChunkType.PROTOCHUNK) {
            var9 = (ProtoChunk)var1;
            var7.addAll(((ProtoChunk)var9).getEntities());
            var10 = ((ProtoChunk)var9).getCarvingMask();
            if (var10 != null) {
                var8 = ((CarvingMask)var10).toArray();
            }
        }
        var9 = new EnumMap<HeightMap.Type, long[]>(HeightMap.Type.class);
        for (Map.Entry entry : var1.getHeightmaps()) {
            if (!var1.getPersistedStatus().heightmapsAfter().contains(entry.getKey())) continue;
            var12 = ((HeightMap)entry.getValue()).getRawData();
            var9.put((HeightMap.Type)((HeightMap.Type)entry.getKey()), (long[])var12.clone());
        }
        var10 = var1.getTicksForSerialization(var02.getGameTime());
        @Nullable ShortList[] shortListArray = (ShortList[])Arrays.stream(var1.getPostProcessing()).map(var0 -> var0 != null && !var0.isEmpty() ? new ShortArrayList(var0) : null).toArray(ShortList[]::new);
        var12 = SerializableChunkData.packStructureData(StructurePieceSerializationContext.fromLevel(var02), var2, var1.getAllStarts(), var1.getAllReferences());
        return new SerializableChunkData(var02.palettedContainerFactory(), var2, var1.getMinSectionY(), var02.getGameTime(), var1.getInhabitedTime(), var1.getPersistedStatus(), Optionull.map(var1.getBlendingData(), BlendingData::pack), var1.getBelowZeroRetrogen(), var1.getUpgradeData().copy(), var8, (Map<HeightMap.Type, long[]>)var9, (IChunkAccess.b)var10, shortListArray, var1.isLightCorrect(), (List<b>)var3, var7, (List<NBTTagCompound>)var6, (NBTTagCompound)var12);
    }

    public NBTTagCompound write() {
        NBTTagCompound var0 = GameProfileSerializer.addCurrentDataVersion(new NBTTagCompound());
        var0.putInt(X_POS_TAG, this.chunkPos.x);
        var0.putInt("yPos", this.minSectionY);
        var0.putInt(Z_POS_TAG, this.chunkPos.z);
        var0.putLong("LastUpdate", this.lastUpdateTime);
        var0.putLong("InhabitedTime", this.inhabitedTime);
        var0.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(this.chunkStatus).toString());
        var0.storeNullable("blending_data", BlendingData.d.CODEC, this.blendingData);
        var0.storeNullable("below_zero_retrogen", BelowZeroRetrogen.CODEC, this.belowZeroRetrogen);
        if (!this.upgradeData.isEmpty()) {
            var0.put(TAG_UPGRADE_DATA, this.upgradeData.write());
        }
        NBTTagList var12 = new NBTTagList();
        Codec<DataPaletteBlock<IBlockData>> var22 = this.containerFactory.blockStatesContainerCodec();
        Codec<PalettedContainerRO<Holder<BiomeBase>>> var3 = this.containerFactory.biomeContainerCodec();
        for (b b2 : this.sectionData) {
            NBTTagCompound var6 = new NBTTagCompound();
            ChunkSection var7 = b2.chunkSection;
            if (var7 != null) {
                var6.store("block_states", var22, var7.getStates());
                var6.store("biomes", var3, var7.getBiomes());
            }
            if (b2.blockLight != null) {
                var6.putByteArray(BLOCK_LIGHT_TAG, b2.blockLight.getData());
            }
            if (b2.skyLight != null) {
                var6.putByteArray(SKY_LIGHT_TAG, b2.skyLight.getData());
            }
            if (var6.isEmpty()) continue;
            var6.putByte("Y", (byte)b2.y);
            var12.add(var6);
        }
        var0.put(SECTIONS_TAG, var12);
        if (this.lightCorrect) {
            var0.putBoolean(IS_LIGHT_ON_TAG, true);
        }
        NBTTagList var4 = new NBTTagList();
        var4.addAll(this.blockEntities);
        var0.put("block_entities", var4);
        if (this.chunkStatus.getChunkType() == ChunkType.PROTOCHUNK) {
            NBTTagList nBTTagList = new NBTTagList();
            nBTTagList.addAll(this.entities);
            var0.put("entities", nBTTagList);
            if (this.carvingMask != null) {
                var0.putLongArray("carving_mask", this.carvingMask);
            }
        }
        SerializableChunkData.saveTicks(var0, this.packedTicks);
        var0.put("PostProcessing", SerializableChunkData.packOffsets(this.postProcessingSections));
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        this.heightmaps.forEach((var1, var2) -> nBTTagCompound.put(var1.getSerializationKey(), new NBTTagLongArray((long[])var2)));
        var0.put(HEIGHTMAPS_TAG, nBTTagCompound);
        var0.put("structures", this.structureData);
        return var0;
    }

    private static void saveTicks(NBTTagCompound var0, IChunkAccess.b var1) {
        var0.store(BLOCK_TICKS_TAG, BLOCK_TICKS_CODEC, var1.blocks());
        var0.store(FLUID_TICKS_TAG, FLUID_TICKS_CODEC, var1.fluids());
    }

    public static ChunkStatus getChunkStatusFromTag(@Nullable NBTTagCompound var0) {
        return var0 != null ? var0.read("Status", ChunkStatus.CODEC).orElse(ChunkStatus.EMPTY) : ChunkStatus.EMPTY;
    }

    private static @Nullable Chunk.c postLoadChunk(WorldServer var0, List<NBTTagCompound> var1, List<NBTTagCompound> var2) {
        if (var1.isEmpty() && var2.isEmpty()) {
            return null;
        }
        return var3 -> {
            if (!var1.isEmpty()) {
                try (ProblemReporter.j var4 = new ProblemReporter.j(var3.problemPath(), LOGGER);){
                    var0.addLegacyChunkEntities(EntityTypes.loadEntitiesRecursive(TagValueInput.create((ProblemReporter)var4, (HolderLookup.a)var0.registryAccess(), var1), var0, EntitySpawnReason.LOAD));
                }
            }
            for (NBTTagCompound var5 : var2) {
                boolean var6 = var5.getBooleanOr("keepPacked", false);
                if (var6) {
                    var3.setBlockEntityNbt(var5);
                    continue;
                }
                BlockPosition var7 = TileEntity.getPosFromTag(var3.getPos(), var5);
                TileEntity var8 = TileEntity.loadStatic(var7, var3.getBlockState(var7), var5, var0.registryAccess());
                if (var8 == null) continue;
                var3.setBlockEntity(var8);
            }
        };
    }

    private static NBTTagCompound packStructureData(StructurePieceSerializationContext var0, ChunkCoordIntPair var1, Map<Structure, StructureStart> var2, Map<Structure, LongSet> var3) {
        NBTTagCompound var4 = new NBTTagCompound();
        NBTTagCompound var5 = new NBTTagCompound();
        HolderLookup.b var6 = var0.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        for (Map.Entry<Structure, StructureStart> var8 : var2.entrySet()) {
            Map.Entry<Structure, LongSet> var9 = var6.getKey(var8.getKey());
            var5.put(((MinecraftKey)((Object)var9)).toString(), var8.getValue().createTag(var0, var1));
        }
        var4.put("starts", var5);
        NBTTagCompound var7 = new NBTTagCompound();
        for (Map.Entry<Structure, LongSet> var9 : var3.entrySet()) {
            if (((LongSet)var9.getValue()).isEmpty()) continue;
            MinecraftKey var10 = var6.getKey((Structure)var9.getKey());
            var7.putLongArray(var10.toString(), ((LongSet)var9.getValue()).toLongArray());
        }
        var4.put("References", var7);
        return var4;
    }

    private static Map<Structure, StructureStart> unpackStructureStart(StructurePieceSerializationContext var0, NBTTagCompound var1, long var2) {
        HashMap var4 = Maps.newHashMap();
        HolderLookup.b var5 = var0.registryAccess().lookupOrThrow(Registries.STRUCTURE);
        NBTTagCompound var6 = var1.getCompoundOrEmpty("starts");
        for (String var8 : var6.keySet()) {
            MinecraftKey var9 = MinecraftKey.tryParse(var8);
            Structure var10 = (Structure)var5.getValue(var9);
            if (var10 == null) {
                LOGGER.error("Unknown structure start: {}", (Object)var9);
                continue;
            }
            StructureStart var11 = StructureStart.loadStaticStart(var0, var6.getCompoundOrEmpty(var8), var2);
            if (var11 == null) continue;
            var4.put(var10, var11);
        }
        return var4;
    }

    private static Map<Structure, LongSet> unpackStructureReferences(IRegistryCustom var0, ChunkCoordIntPair var1, NBTTagCompound var2) {
        HashMap var3 = Maps.newHashMap();
        HolderLookup.b var4 = var0.lookupOrThrow(Registries.STRUCTURE);
        NBTTagCompound var5 = var2.getCompoundOrEmpty("References");
        var5.forEach((arg_0, arg_1) -> SerializableChunkData.a((IRegistry)var4, var1, var3, arg_0, arg_1));
        return var3;
    }

    private static NBTTagList packOffsets(@Nullable ShortList[] var0) {
        NBTTagList var1 = new NBTTagList();
        for (ShortList var5 : var0) {
            NBTTagList var6 = new NBTTagList();
            if (var5 != null) {
                for (int var7 = 0; var7 < var5.size(); ++var7) {
                    var6.add(NBTTagShort.valueOf(var5.getShort(var7)));
                }
            }
            var1.add(var6);
        }
        return var1;
    }

    private static /* synthetic */ void a(IRegistry var0, ChunkCoordIntPair var1, Map var22, String var3, NBTBase var4) {
        MinecraftKey var5 = MinecraftKey.tryParse(var3);
        Structure var6 = (Structure)var0.getValue(var5);
        if (var6 == null) {
            LOGGER.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)var5, (Object)var1);
            return;
        }
        Optional<long[]> var7 = var4.asLongArray();
        if (var7.isEmpty()) {
            return;
        }
        var22.put(var6, new LongOpenHashSet(Arrays.stream(var7.get()).filter(var2 -> {
            ChunkCoordIntPair var4 = new ChunkCoordIntPair(var2);
            if (var4.getChessboardDistance(var1) > 8) {
                LOGGER.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{var5, var4, var1});
                return false;
            }
            return true;
        }).toArray()));
    }

    public static final class b
    extends Record {
        final int y;
        final @Nullable ChunkSection chunkSection;
        final @Nullable NibbleArray blockLight;
        final @Nullable NibbleArray skyLight;

        public b(int var0, @Nullable ChunkSection var1, @Nullable NibbleArray var2, @Nullable NibbleArray var3) {
            this.y = var0;
            this.chunkSection = var1;
            this.blockLight = var2;
            this.skyLight = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "y;chunkSection;blockLight;skyLight", "y", "chunkSection", "blockLight", "skyLight"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "y;chunkSection;blockLight;skyLight", "y", "chunkSection", "blockLight", "skyLight"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "y;chunkSection;blockLight;skyLight", "y", "chunkSection", "blockLight", "skyLight"}, this, var0);
        }

        public int y() {
            return this.y;
        }

        public @Nullable ChunkSection chunkSection() {
            return this.chunkSection;
        }

        public @Nullable NibbleArray blockLight() {
            return this.blockLight;
        }

        public @Nullable NibbleArray skyLight() {
            return this.skyLight;
        }
    }

    public static class a
    extends NbtException {
        public a(String var0) {
            super(var0);
        }
    }
}

