/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blockpredicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;

public class InsideWorldBoundsPredicate
implements BlockPredicate {
    public static final MapCodec<InsideWorldBoundsPredicate> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BaseBlockPosition.offsetCodec(16).optionalFieldOf("offset", (Object)BlockPosition.ZERO).forGetter(var0 -> var0.offset)).apply((Applicative)var02, InsideWorldBoundsPredicate::new));
    private final BaseBlockPosition offset;

    public InsideWorldBoundsPredicate(BaseBlockPosition var0) {
        this.offset = var0;
    }

    @Override
    public boolean test(GeneratorAccessSeed var0, BlockPosition var1) {
        return !var0.isOutsideBuildHeight(var1.offset(this.offset));
    }

    @Override
    public BlockPredicateType<?> type() {
        return BlockPredicateType.INSIDE_WORLD_BOUNDS;
    }

    @Override
    public /* synthetic */ boolean test(Object object, Object object2) {
        return this.test((GeneratorAccessSeed)object, (BlockPosition)object2);
    }
}

