/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.FallenTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;

public class FallenTreeFeature
extends WorldGenerator<FallenTreeConfiguration> {
    private static final int STUMP_HEIGHT = 1;
    private static final int STUMP_HEIGHT_PLUS_EMPTY_SPACE = 2;
    private static final int FALLEN_LOG_MAX_FALL_HEIGHT_TO_GROUND = 5;
    private static final int FALLEN_LOG_MAX_GROUND_GAP = 2;
    private static final int FALLEN_LOG_MAX_SPACE_FROM_STUMP = 2;

    public FallenTreeFeature(Codec<FallenTreeConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<FallenTreeConfiguration> var0) {
        this.placeFallenTree(var0.config(), var0.origin(), var0.level(), var0.random());
        return true;
    }

    private void placeFallenTree(FallenTreeConfiguration var0, BlockPosition var1, GeneratorAccessSeed var2, RandomSource var3) {
        this.placeStump(var0, var2, var3, var1.mutable());
        EnumDirection var4 = EnumDirection.EnumDirectionLimit.HORIZONTAL.getRandomDirection(var3);
        int var5 = var0.logLength.sample(var3) - 2;
        BlockPosition.MutableBlockPosition var6 = var1.relative(var4, 2 + var3.nextInt(2)).mutable();
        this.setGroundHeightForFallenLogStartPos(var2, var6);
        if (this.canPlaceEntireFallenLog(var2, var5, var6, var4)) {
            this.placeFallenLog(var0, var2, var3, var5, var6, var4);
        }
    }

    private void setGroundHeightForFallenLogStartPos(GeneratorAccessSeed var0, BlockPosition.MutableBlockPosition var1) {
        var1.move(EnumDirection.UP, 1);
        for (int var2 = 0; var2 < 6; ++var2) {
            if (this.mayPlaceOn(var0, var1)) {
                return;
            }
            var1.move(EnumDirection.DOWN);
        }
    }

    private void placeStump(FallenTreeConfiguration var0, GeneratorAccessSeed var1, RandomSource var2, BlockPosition.MutableBlockPosition var3) {
        BlockPosition var4 = this.placeLogBlock(var0, var1, var2, var3, Function.identity());
        this.decorateLogs(var1, var2, Set.of(var4), var0.stumpDecorators);
    }

    private boolean canPlaceEntireFallenLog(GeneratorAccessSeed var0, int var1, BlockPosition.MutableBlockPosition var2, EnumDirection var3) {
        int var4 = 0;
        for (int var5 = 0; var5 < var1; ++var5) {
            if (!WorldGenTrees.validTreePos(var0, var2)) {
                return false;
            }
            if (!this.isOverSolidGround(var0, var2)) {
                if (++var4 > 2) {
                    return false;
                }
            } else {
                var4 = 0;
            }
            var2.move(var3);
        }
        var2.move(var3.getOpposite(), var1);
        return true;
    }

    private void placeFallenLog(FallenTreeConfiguration var0, GeneratorAccessSeed var1, RandomSource var2, int var3, BlockPosition.MutableBlockPosition var4, EnumDirection var5) {
        HashSet<BlockPosition> var6 = new HashSet<BlockPosition>();
        for (int var7 = 0; var7 < var3; ++var7) {
            var6.add(this.placeLogBlock(var0, var1, var2, var4, FallenTreeFeature.getSidewaysStateModifier(var5)));
            var4.move(var5);
        }
        this.decorateLogs(var1, var2, var6, var0.logDecorators);
    }

    private boolean mayPlaceOn(GeneratorAccess var0, BlockPosition var1) {
        return WorldGenTrees.validTreePos(var0, var1) && this.isOverSolidGround(var0, var1);
    }

    private boolean isOverSolidGround(GeneratorAccess var0, BlockPosition var1) {
        return var0.getBlockState(var1.below()).isFaceSturdy(var0, var1, EnumDirection.UP);
    }

    private BlockPosition placeLogBlock(FallenTreeConfiguration var0, GeneratorAccessSeed var1, RandomSource var2, BlockPosition.MutableBlockPosition var3, Function<IBlockData, IBlockData> var4) {
        var1.setBlock(var3, var4.apply(var0.trunkProvider.getState(var2, var3)), 3);
        this.markAboveForPostProcessing(var1, var3);
        return var3.immutable();
    }

    private void decorateLogs(GeneratorAccessSeed var0, RandomSource var12, Set<BlockPosition> var2, List<WorldGenFeatureTree> var3) {
        if (!var3.isEmpty()) {
            WorldGenFeatureTree.a var4 = new WorldGenFeatureTree.a(var0, this.getDecorationSetter(var0), var12, var2, Set.of(), Set.of());
            var3.forEach(var1 -> var1.place(var4));
        }
    }

    private BiConsumer<BlockPosition, IBlockData> getDecorationSetter(GeneratorAccessSeed var0) {
        return (var1, var2) -> var0.setBlock((BlockPosition)var1, (IBlockData)var2, 19);
    }

    private static Function<IBlockData, IBlockData> getSidewaysStateModifier(EnumDirection var0) {
        return var1 -> (IBlockData)var1.trySetValue(BlockRotatable.AXIS, var0.getAxis());
    }
}

