/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureDeltaConfiguration;

public class WorldGenFeatureDelta
extends WorldGenerator<WorldGenFeatureDeltaConfiguration> {
    private static final ImmutableList<Block> CANNOT_REPLACE = ImmutableList.of((Object)Blocks.BEDROCK, (Object)Blocks.NETHER_BRICKS, (Object)Blocks.NETHER_BRICK_FENCE, (Object)Blocks.NETHER_BRICK_STAIRS, (Object)Blocks.NETHER_WART, (Object)Blocks.CHEST, (Object)Blocks.SPAWNER);
    private static final EnumDirection[] DIRECTIONS = EnumDirection.values();
    private static final double RIM_SPAWN_CHANCE = 0.9;

    public WorldGenFeatureDelta(Codec<WorldGenFeatureDeltaConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureDeltaConfiguration> var0) {
        boolean var1 = false;
        RandomSource var2 = var0.random();
        GeneratorAccessSeed var3 = var0.level();
        WorldGenFeatureDeltaConfiguration var4 = var0.config();
        BlockPosition var5 = var0.origin();
        boolean var6 = var2.nextDouble() < 0.9;
        int var7 = var6 ? var4.rimSize().sample(var2) : 0;
        int var8 = var6 ? var4.rimSize().sample(var2) : 0;
        boolean var9 = var6 && var7 != 0 && var8 != 0;
        int var10 = var4.size().sample(var2);
        int var11 = var4.size().sample(var2);
        int var12 = Math.max(var10, var11);
        for (BlockPosition var14 : BlockPosition.withinManhattan(var5, var10, 0, var11)) {
            BlockPosition var15;
            if (var14.distManhattan(var5) > var12) break;
            if (!WorldGenFeatureDelta.isClear(var3, var14, var4)) continue;
            if (var9) {
                var1 = true;
                this.setBlock(var3, var14, var4.rim());
            }
            if (!WorldGenFeatureDelta.isClear(var3, var15 = var14.offset(var7, 0, var8), var4)) continue;
            var1 = true;
            this.setBlock(var3, var15, var4.contents());
        }
        return var1;
    }

    private static boolean isClear(GeneratorAccess var0, BlockPosition var1, WorldGenFeatureDeltaConfiguration var2) {
        IBlockData var3 = var0.getBlockState(var1);
        if (var3.is(var2.contents().getBlock())) {
            return false;
        }
        if (CANNOT_REPLACE.contains((Object)var3.getBlock())) {
            return false;
        }
        for (EnumDirection var7 : DIRECTIONS) {
            boolean var8 = var0.getBlockState(var1.relative(var7)).isAir();
            if ((!var8 || var7 == EnumDirection.UP) && (var8 || var7 != EnumDirection.UP)) continue;
            return false;
        }
        return true;
    }
}

