/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.BlockGrowingTop;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;

public class WorldGenFeatureWeepingVines
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    private static final EnumDirection[] DIRECTIONS = EnumDirection.values();

    public WorldGenFeatureWeepingVines(Codec<WorldGenFeatureEmptyConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> var0) {
        GeneratorAccessSeed var1 = var0.level();
        BlockPosition var2 = var0.origin();
        RandomSource var3 = var0.random();
        if (!var1.isEmptyBlock(var2)) {
            return false;
        }
        IBlockData var4 = var1.getBlockState(var2.above());
        if (!var4.is(Blocks.NETHERRACK) && !var4.is(Blocks.NETHER_WART_BLOCK)) {
            return false;
        }
        this.placeRoofNetherWart(var1, var3, var2);
        this.placeRoofWeepingVines(var1, var3, var2);
        return true;
    }

    private void placeRoofNetherWart(GeneratorAccess var0, RandomSource var1, BlockPosition var2) {
        var0.setBlock(var2, Blocks.NETHER_WART_BLOCK.defaultBlockState(), 2);
        BlockPosition.MutableBlockPosition var3 = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition var4 = new BlockPosition.MutableBlockPosition();
        for (int var5 = 0; var5 < 200; ++var5) {
            var3.setWithOffset(var2, var1.nextInt(6) - var1.nextInt(6), var1.nextInt(2) - var1.nextInt(5), var1.nextInt(6) - var1.nextInt(6));
            if (!var0.isEmptyBlock(var3)) continue;
            int var6 = 0;
            for (EnumDirection var10 : DIRECTIONS) {
                IBlockData var11 = var0.getBlockState(var4.setWithOffset((BaseBlockPosition)var3, var10));
                if (var11.is(Blocks.NETHERRACK) || var11.is(Blocks.NETHER_WART_BLOCK)) {
                    ++var6;
                }
                if (var6 > 1) break;
            }
            if (var6 != true) continue;
            var0.setBlock(var3, Blocks.NETHER_WART_BLOCK.defaultBlockState(), 2);
        }
    }

    private void placeRoofWeepingVines(GeneratorAccess var0, RandomSource var1, BlockPosition var2) {
        BlockPosition.MutableBlockPosition var3 = new BlockPosition.MutableBlockPosition();
        for (int var4 = 0; var4 < 100; ++var4) {
            IBlockData var5;
            var3.setWithOffset(var2, var1.nextInt(8) - var1.nextInt(8), var1.nextInt(2) - var1.nextInt(7), var1.nextInt(8) - var1.nextInt(8));
            if (!var0.isEmptyBlock(var3) || !(var5 = var0.getBlockState((BlockPosition)var3.above())).is(Blocks.NETHERRACK) && !var5.is(Blocks.NETHER_WART_BLOCK)) continue;
            int var6 = MathHelper.nextInt(var1, 1, 8);
            if (var1.nextInt(6) == 0) {
                var6 *= 2;
            }
            if (var1.nextInt(5) == 0) {
                var6 = 1;
            }
            int var7 = 17;
            int var8 = 25;
            WorldGenFeatureWeepingVines.placeWeepingVinesColumn(var0, var1, var3, var6, 17, 25);
        }
    }

    public static void placeWeepingVinesColumn(GeneratorAccess var0, RandomSource var1, BlockPosition.MutableBlockPosition var2, int var3, int var4, int var5) {
        for (int var6 = 0; var6 <= var3; ++var6) {
            if (var0.isEmptyBlock(var2)) {
                if (var6 == var3 || !var0.isEmptyBlock((BlockPosition)var2.below())) {
                    var0.setBlock(var2, (IBlockData)Blocks.WEEPING_VINES.defaultBlockState().setValue(BlockGrowingTop.AGE, MathHelper.nextInt(var1, var4, var5)), 2);
                    break;
                }
                var0.setBlock(var2, Blocks.WEEPING_VINES_PLANT.defaultBlockState(), 2);
            }
            var2.move(EnumDirection.DOWN);
        }
    }
}

