/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.flat;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.flat.WorldGenFlatLayerInfo;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class FlatLevelGeneratorPresets {
    public static final ResourceKey<FlatLevelGeneratorPreset> CLASSIC_FLAT = FlatLevelGeneratorPresets.register("classic_flat");
    public static final ResourceKey<FlatLevelGeneratorPreset> TUNNELERS_DREAM = FlatLevelGeneratorPresets.register("tunnelers_dream");
    public static final ResourceKey<FlatLevelGeneratorPreset> WATER_WORLD = FlatLevelGeneratorPresets.register("water_world");
    public static final ResourceKey<FlatLevelGeneratorPreset> OVERWORLD = FlatLevelGeneratorPresets.register("overworld");
    public static final ResourceKey<FlatLevelGeneratorPreset> SNOWY_KINGDOM = FlatLevelGeneratorPresets.register("snowy_kingdom");
    public static final ResourceKey<FlatLevelGeneratorPreset> BOTTOMLESS_PIT = FlatLevelGeneratorPresets.register("bottomless_pit");
    public static final ResourceKey<FlatLevelGeneratorPreset> DESERT = FlatLevelGeneratorPresets.register("desert");
    public static final ResourceKey<FlatLevelGeneratorPreset> REDSTONE_READY = FlatLevelGeneratorPresets.register("redstone_ready");
    public static final ResourceKey<FlatLevelGeneratorPreset> THE_VOID = FlatLevelGeneratorPresets.register("the_void");

    public static void bootstrap(BootstrapContext<FlatLevelGeneratorPreset> var0) {
        new a(var0).run();
    }

    private static ResourceKey<FlatLevelGeneratorPreset> register(String var0) {
        return ResourceKey.create(Registries.FLAT_LEVEL_GENERATOR_PRESET, MinecraftKey.withDefaultNamespace(var0));
    }

    static class a {
        private final BootstrapContext<FlatLevelGeneratorPreset> context;

        a(BootstrapContext<FlatLevelGeneratorPreset> var0) {
            this.context = var0;
        }

        private void register(ResourceKey<FlatLevelGeneratorPreset> var0, IMaterial var1, ResourceKey<BiomeBase> var2, Set<ResourceKey<StructureSet>> var3, boolean var4, boolean var5, WorldGenFlatLayerInfo ... var6) {
            HolderGetter<StructureSet> var7 = this.context.lookup(Registries.STRUCTURE_SET);
            HolderGetter<PlacedFeature> var8 = this.context.lookup(Registries.PLACED_FEATURE);
            HolderGetter<BiomeBase> var9 = this.context.lookup(Registries.BIOME);
            HolderSet.a var10 = HolderSet.direct(var3.stream().map(var7::getOrThrow).collect(Collectors.toList()));
            GeneratorSettingsFlat var11 = new GeneratorSettingsFlat(Optional.of(var10), var9.getOrThrow(var2), GeneratorSettingsFlat.createLakesList(var8));
            if (var4) {
                var11.setDecoration();
            }
            if (var5) {
                var11.setAddLakes();
            }
            for (int var12 = var6.length - 1; var12 >= 0; --var12) {
                var11.getLayersInfo().add(var6[var12]);
            }
            this.context.register(var0, new FlatLevelGeneratorPreset(var1.asItem().builtInRegistryHolder(), var11));
        }

        public void run() {
            this.register(CLASSIC_FLAT, Blocks.GRASS_BLOCK, Biomes.PLAINS, (Set<ResourceKey<StructureSet>>)ImmutableSet.of(BuiltinStructureSets.VILLAGES), false, false, new WorldGenFlatLayerInfo(1, Blocks.GRASS_BLOCK), new WorldGenFlatLayerInfo(2, Blocks.DIRT), new WorldGenFlatLayerInfo(1, Blocks.BEDROCK));
            this.register(TUNNELERS_DREAM, Blocks.STONE, Biomes.WINDSWEPT_HILLS, (Set<ResourceKey<StructureSet>>)ImmutableSet.of(BuiltinStructureSets.MINESHAFTS, BuiltinStructureSets.STRONGHOLDS), true, false, new WorldGenFlatLayerInfo(1, Blocks.GRASS_BLOCK), new WorldGenFlatLayerInfo(5, Blocks.DIRT), new WorldGenFlatLayerInfo(230, Blocks.STONE), new WorldGenFlatLayerInfo(1, Blocks.BEDROCK));
            this.register(WATER_WORLD, Items.WATER_BUCKET, Biomes.DEEP_OCEAN, (Set<ResourceKey<StructureSet>>)ImmutableSet.of(BuiltinStructureSets.OCEAN_RUINS, BuiltinStructureSets.SHIPWRECKS, BuiltinStructureSets.OCEAN_MONUMENTS), false, false, new WorldGenFlatLayerInfo(90, Blocks.WATER), new WorldGenFlatLayerInfo(5, Blocks.GRAVEL), new WorldGenFlatLayerInfo(5, Blocks.DIRT), new WorldGenFlatLayerInfo(5, Blocks.STONE), new WorldGenFlatLayerInfo(64, Blocks.DEEPSLATE), new WorldGenFlatLayerInfo(1, Blocks.BEDROCK));
            this.register(OVERWORLD, Blocks.SHORT_GRASS, Biomes.PLAINS, (Set<ResourceKey<StructureSet>>)ImmutableSet.of(BuiltinStructureSets.VILLAGES, BuiltinStructureSets.MINESHAFTS, BuiltinStructureSets.PILLAGER_OUTPOSTS, BuiltinStructureSets.RUINED_PORTALS, BuiltinStructureSets.STRONGHOLDS), true, true, new WorldGenFlatLayerInfo(1, Blocks.GRASS_BLOCK), new WorldGenFlatLayerInfo(3, Blocks.DIRT), new WorldGenFlatLayerInfo(59, Blocks.STONE), new WorldGenFlatLayerInfo(1, Blocks.BEDROCK));
            this.register(SNOWY_KINGDOM, Blocks.SNOW, Biomes.SNOWY_PLAINS, (Set<ResourceKey<StructureSet>>)ImmutableSet.of(BuiltinStructureSets.VILLAGES, BuiltinStructureSets.IGLOOS), false, false, new WorldGenFlatLayerInfo(1, Blocks.SNOW), new WorldGenFlatLayerInfo(1, Blocks.GRASS_BLOCK), new WorldGenFlatLayerInfo(3, Blocks.DIRT), new WorldGenFlatLayerInfo(59, Blocks.STONE), new WorldGenFlatLayerInfo(1, Blocks.BEDROCK));
            this.register(BOTTOMLESS_PIT, Items.FEATHER, Biomes.PLAINS, (Set<ResourceKey<StructureSet>>)ImmutableSet.of(BuiltinStructureSets.VILLAGES), false, false, new WorldGenFlatLayerInfo(1, Blocks.GRASS_BLOCK), new WorldGenFlatLayerInfo(3, Blocks.DIRT), new WorldGenFlatLayerInfo(2, Blocks.COBBLESTONE));
            this.register(DESERT, Blocks.SAND, Biomes.DESERT, (Set<ResourceKey<StructureSet>>)ImmutableSet.of(BuiltinStructureSets.VILLAGES, BuiltinStructureSets.DESERT_PYRAMIDS, BuiltinStructureSets.MINESHAFTS, BuiltinStructureSets.STRONGHOLDS), true, false, new WorldGenFlatLayerInfo(8, Blocks.SAND), new WorldGenFlatLayerInfo(52, Blocks.SANDSTONE), new WorldGenFlatLayerInfo(3, Blocks.STONE), new WorldGenFlatLayerInfo(1, Blocks.BEDROCK));
            this.register(REDSTONE_READY, Items.REDSTONE, Biomes.DESERT, (Set<ResourceKey<StructureSet>>)ImmutableSet.of(), false, false, new WorldGenFlatLayerInfo(116, Blocks.SANDSTONE), new WorldGenFlatLayerInfo(3, Blocks.STONE), new WorldGenFlatLayerInfo(1, Blocks.BEDROCK));
            this.register(THE_VOID, Blocks.BARRIER, Biomes.THE_VOID, (Set<ResourceKey<StructureSet>>)ImmutableSet.of(), true, false, new WorldGenFlatLayerInfo(1, Blocks.AIR));
        }
    }
}

