/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.flat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.DimensionManager;

public class WorldGenFlatLayerInfo {
    public static final Codec<WorldGenFlatLayerInfo> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.intRange((int)0, (int)DimensionManager.Y_SIZE).fieldOf("height").forGetter(WorldGenFlatLayerInfo::getHeight), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").orElse((Object)Blocks.AIR).forGetter(var0 -> var0.getBlockState().getBlock())).apply((Applicative)var02, WorldGenFlatLayerInfo::new));
    private final Block block;
    private final int height;

    public WorldGenFlatLayerInfo(int var0, Block var1) {
        this.height = var0;
        this.block = var1;
    }

    public int getHeight() {
        return this.height;
    }

    public IBlockData getBlockState() {
        return this.block.defaultBlockState();
    }

    public WorldGenFlatLayerInfo heightLimited(int var0) {
        if (this.height > var0) {
            return new WorldGenFlatLayerInfo(var0, this.block);
        }
        return this;
    }

    public String toString() {
        return (String)(this.height != 1 ? this.height + "*" : "") + String.valueOf(BuiltInRegistries.BLOCK.getKey(this.block));
    }
}

