/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.heightproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import org.slf4j.Logger;

public class UniformHeight
extends HeightProvider {
    public static final MapCodec<UniformHeight> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)VerticalAnchor.CODEC.fieldOf("min_inclusive").forGetter(var0 -> var0.minInclusive), (App)VerticalAnchor.CODEC.fieldOf("max_inclusive").forGetter(var0 -> var0.maxInclusive)).apply((Applicative)var02, UniformHeight::new));
    private static final Logger LOGGER = LogUtils.getLogger();
    private final VerticalAnchor minInclusive;
    private final VerticalAnchor maxInclusive;
    private final LongSet warnedFor = new LongOpenHashSet();

    private UniformHeight(VerticalAnchor var0, VerticalAnchor var1) {
        this.minInclusive = var0;
        this.maxInclusive = var1;
    }

    public static UniformHeight of(VerticalAnchor var0, VerticalAnchor var1) {
        return new UniformHeight(var0, var1);
    }

    @Override
    public int sample(RandomSource var0, WorldGenerationContext var1) {
        int var3;
        int var2 = this.minInclusive.resolveY(var1);
        if (var2 > (var3 = this.maxInclusive.resolveY(var1))) {
            if (this.warnedFor.add((long)var2 << 32 | (long)var3)) {
                LOGGER.warn("Empty height range: {}", (Object)this);
            }
            return var2;
        }
        return MathHelper.randomBetweenInclusive(var0, var2, var3);
    }

    @Override
    public HeightProviderType<?> getType() {
        return HeightProviderType.UNIFORM;
    }

    public String toString() {
        return "[" + String.valueOf(this.minInclusive) + "-" + String.valueOf(this.maxInclusive) + "]";
    }
}

