/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class PlacementContext
extends WorldGenerationContext {
    private final GeneratorAccessSeed level;
    private final ChunkGenerator generator;
    private final Optional<PlacedFeature> topFeature;

    public PlacementContext(GeneratorAccessSeed var0, ChunkGenerator var1, Optional<PlacedFeature> var2) {
        super(var1, var0);
        this.level = var0;
        this.generator = var1;
        this.topFeature = var2;
    }

    public int getHeight(HeightMap.Type var0, int var1, int var2) {
        return this.level.getHeight(var0, var1, var2);
    }

    public CarvingMask getCarvingMask(ChunkCoordIntPair var0) {
        return ((ProtoChunk)this.level.getChunk(var0.x, var0.z)).getOrCreateCarvingMask();
    }

    public IBlockData getBlockState(BlockPosition var0) {
        return this.level.getBlockState(var0);
    }

    public int getMinY() {
        return this.level.getMinY();
    }

    public GeneratorAccessSeed getLevel() {
        return this.level;
    }

    public Optional<PlacedFeature> topFeature() {
        return this.topFeature;
    }

    public ChunkGenerator generator() {
        return this.generator;
    }
}

