/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.zombie.EntityDrowned;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.DefinedStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorPredicates;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestTrue;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;

public class OceanRuinPieces {
    static final DefinedStructureProcessor WARM_SUSPICIOUS_BLOCK_PROCESSOR = OceanRuinPieces.archyRuleProcessor(Blocks.SAND, Blocks.SUSPICIOUS_SAND, LootTables.OCEAN_RUIN_WARM_ARCHAEOLOGY);
    static final DefinedStructureProcessor COLD_SUSPICIOUS_BLOCK_PROCESSOR = OceanRuinPieces.archyRuleProcessor(Blocks.GRAVEL, Blocks.SUSPICIOUS_GRAVEL, LootTables.OCEAN_RUIN_COLD_ARCHAEOLOGY);
    private static final MinecraftKey[] WARM_RUINS = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/warm_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_4"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_5"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_6"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_7"), MinecraftKey.withDefaultNamespace("underwater_ruin/warm_8")};
    private static final MinecraftKey[] RUINS_BRICK = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/brick_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_4"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_5"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_6"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_7"), MinecraftKey.withDefaultNamespace("underwater_ruin/brick_8")};
    private static final MinecraftKey[] RUINS_CRACKED = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_4"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_5"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_6"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_7"), MinecraftKey.withDefaultNamespace("underwater_ruin/cracked_8")};
    private static final MinecraftKey[] RUINS_MOSSY = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_4"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_5"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_6"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_7"), MinecraftKey.withDefaultNamespace("underwater_ruin/mossy_8")};
    private static final MinecraftKey[] BIG_RUINS_BRICK = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/big_brick_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_brick_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_brick_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_brick_8")};
    private static final MinecraftKey[] BIG_RUINS_MOSSY = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/big_mossy_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_mossy_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_mossy_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_mossy_8")};
    private static final MinecraftKey[] BIG_RUINS_CRACKED = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/big_cracked_1"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_cracked_2"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_cracked_3"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_cracked_8")};
    private static final MinecraftKey[] BIG_WARM_RUINS = new MinecraftKey[]{MinecraftKey.withDefaultNamespace("underwater_ruin/big_warm_4"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_warm_5"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_warm_6"), MinecraftKey.withDefaultNamespace("underwater_ruin/big_warm_7")};

    private static DefinedStructureProcessor archyRuleProcessor(Block var0, Block var1, ResourceKey<LootTable> var2) {
        return new CappedProcessor(new DefinedStructureProcessorRule(List.of(new DefinedStructureProcessorPredicates(new DefinedStructureTestBlock(var0), DefinedStructureTestTrue.INSTANCE, PosRuleTestTrue.INSTANCE, var1.defaultBlockState(), new AppendLoot(var2)))), ConstantInt.of(5));
    }

    private static MinecraftKey getSmallWarmRuin(RandomSource var0) {
        return SystemUtils.getRandom(WARM_RUINS, var0);
    }

    private static MinecraftKey getBigWarmRuin(RandomSource var0) {
        return SystemUtils.getRandom(BIG_WARM_RUINS, var0);
    }

    public static void addPieces(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2, StructurePieceAccessor var3, RandomSource var4, OceanRuinStructure var5) {
        boolean var6 = var4.nextFloat() <= var5.largeProbability;
        float var7 = var6 ? 0.9f : 0.8f;
        OceanRuinPieces.addPiece(var0, var1, var2, var3, var4, var5, var6, var7);
        if (var6 && var4.nextFloat() <= var5.clusterProbability) {
            OceanRuinPieces.addClusterRuins(var0, var4, var2, var1, var5, var3);
        }
    }

    private static void addClusterRuins(StructureTemplateManager var0, RandomSource var1, EnumBlockRotation var2, BlockPosition var3, OceanRuinStructure var4, StructurePieceAccessor var5) {
        BlockPosition var6 = new BlockPosition(var3.getX(), 90, var3.getZ());
        BlockPosition var7 = DefinedStructure.transform(new BlockPosition(15, 0, 15), EnumBlockMirror.NONE, var2, BlockPosition.ZERO).offset(var6);
        StructureBoundingBox var8 = StructureBoundingBox.fromCorners(var6, var7);
        BlockPosition var9 = new BlockPosition(Math.min(var6.getX(), var7.getX()), var6.getY(), Math.min(var6.getZ(), var7.getZ()));
        List<BlockPosition> var10 = OceanRuinPieces.allPositions(var1, var9);
        int var11 = MathHelper.nextInt(var1, 4, 8);
        for (int var12 = 0; var12 < var11; ++var12) {
            EnumBlockRotation var15;
            BlockPosition var16;
            int var13;
            BlockPosition var14;
            StructureBoundingBox var17;
            if (var10.isEmpty() || (var17 = StructureBoundingBox.fromCorners(var14 = var10.remove(var13 = var1.nextInt(var10.size())), var16 = DefinedStructure.transform(new BlockPosition(5, 0, 6), EnumBlockMirror.NONE, var15 = EnumBlockRotation.getRandom(var1), BlockPosition.ZERO).offset(var14))).intersects(var8)) continue;
            OceanRuinPieces.addPiece(var0, var14, var15, var5, var1, var4, false, 0.8f);
        }
    }

    private static List<BlockPosition> allPositions(RandomSource var0, BlockPosition var1) {
        ArrayList var2 = Lists.newArrayList();
        var2.add(var1.offset(-16 + MathHelper.nextInt(var0, 1, 8), 0, 16 + MathHelper.nextInt(var0, 1, 7)));
        var2.add(var1.offset(-16 + MathHelper.nextInt(var0, 1, 8), 0, MathHelper.nextInt(var0, 1, 7)));
        var2.add(var1.offset(-16 + MathHelper.nextInt(var0, 1, 8), 0, -16 + MathHelper.nextInt(var0, 4, 8)));
        var2.add(var1.offset(MathHelper.nextInt(var0, 1, 7), 0, 16 + MathHelper.nextInt(var0, 1, 7)));
        var2.add(var1.offset(MathHelper.nextInt(var0, 1, 7), 0, -16 + MathHelper.nextInt(var0, 4, 6)));
        var2.add(var1.offset(16 + MathHelper.nextInt(var0, 1, 7), 0, 16 + MathHelper.nextInt(var0, 3, 8)));
        var2.add(var1.offset(16 + MathHelper.nextInt(var0, 1, 7), 0, MathHelper.nextInt(var0, 1, 7)));
        var2.add(var1.offset(16 + MathHelper.nextInt(var0, 1, 7), 0, -16 + MathHelper.nextInt(var0, 4, 8)));
        return var2;
    }

    private static void addPiece(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2, StructurePieceAccessor var3, RandomSource var4, OceanRuinStructure var5, boolean var6, float var7) {
        switch (var5.biomeTemp) {
            default: {
                MinecraftKey var8 = var6 ? OceanRuinPieces.getBigWarmRuin(var4) : OceanRuinPieces.getSmallWarmRuin(var4);
                var3.addPiece(new a(var0, var8, var1, var2, var7, var5.biomeTemp, var6));
                break;
            }
            case COLD: {
                MinecraftKey[] var9 = var6 ? BIG_RUINS_BRICK : RUINS_BRICK;
                MinecraftKey[] var10 = var6 ? BIG_RUINS_CRACKED : RUINS_CRACKED;
                MinecraftKey[] var11 = var6 ? BIG_RUINS_MOSSY : RUINS_MOSSY;
                int var12 = var4.nextInt(var9.length);
                var3.addPiece(new a(var0, var9[var12], var1, var2, var7, var5.biomeTemp, var6));
                var3.addPiece(new a(var0, var10[var12], var1, var2, 0.7f, var5.biomeTemp, var6));
                var3.addPiece(new a(var0, var11[var12], var1, var2, 0.5f, var5.biomeTemp, var6));
            }
        }
    }

    public static class a
    extends DefinedStructurePiece {
        private final OceanRuinStructure.a biomeType;
        private final float integrity;
        private final boolean isLarge;

        public a(StructureTemplateManager var0, MinecraftKey var1, BlockPosition var2, EnumBlockRotation var3, float var4, OceanRuinStructure.a var5, boolean var6) {
            super(WorldGenFeatureStructurePieceType.OCEAN_RUIN, 0, var0, var1, var1.toString(), a.makeSettings(var3, var4, var5), var2);
            this.integrity = var4;
            this.biomeType = var5;
            this.isLarge = var6;
        }

        private a(StructureTemplateManager var0, NBTTagCompound var1, EnumBlockRotation var2, float var32, OceanRuinStructure.a var4, boolean var5) {
            super(WorldGenFeatureStructurePieceType.OCEAN_RUIN, var1, var0, var3 -> a.makeSettings(var2, var32, var4));
            this.integrity = var32;
            this.biomeType = var4;
            this.isLarge = var5;
        }

        private static DefinedStructureInfo makeSettings(EnumBlockRotation var0, float var1, OceanRuinStructure.a var2) {
            DefinedStructureProcessor var3 = var2 == OceanRuinStructure.a.COLD ? COLD_SUSPICIOUS_BLOCK_PROCESSOR : WARM_SUSPICIOUS_BLOCK_PROCESSOR;
            return new DefinedStructureInfo().setRotation(var0).setMirror(EnumBlockMirror.NONE).addProcessor(new DefinedStructureProcessorRotation(var1)).addProcessor(DefinedStructureProcessorBlockIgnore.STRUCTURE_AND_AIR).addProcessor(var3);
        }

        public static a create(StructureTemplateManager var0, NBTTagCompound var1) {
            EnumBlockRotation var2 = var1.read("Rot", EnumBlockRotation.LEGACY_CODEC).orElseThrow();
            float var3 = var1.getFloatOr("Integrity", 0.0f);
            OceanRuinStructure.a var4 = var1.read("BiomeType", OceanRuinStructure.a.LEGACY_CODEC).orElseThrow();
            boolean var5 = var1.getBooleanOr("IsLarge", false);
            return new a(var0, var1, var2, var3, var4, var5);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.store("Rot", EnumBlockRotation.LEGACY_CODEC, this.placeSettings.getRotation());
            var1.putFloat("Integrity", this.integrity);
            var1.store("BiomeType", OceanRuinStructure.a.LEGACY_CODEC, this.biomeType);
            var1.putBoolean("IsLarge", this.isLarge);
        }

        @Override
        protected void handleDataMarker(String var0, BlockPosition var1, WorldAccess var2, RandomSource var3, StructureBoundingBox var4) {
            EntityDrowned var5;
            if ("chest".equals(var0)) {
                var2.setBlock(var1, (IBlockData)Blocks.CHEST.defaultBlockState().setValue(BlockChest.WATERLOGGED, var2.getFluidState(var1).is(TagsFluid.WATER)), 2);
                TileEntity var52 = var2.getBlockEntity(var1);
                if (var52 instanceof TileEntityChest) {
                    ((TileEntityChest)var52).setLootTable(this.isLarge ? LootTables.UNDERWATER_RUIN_BIG : LootTables.UNDERWATER_RUIN_SMALL, var3.nextLong());
                }
            } else if ("drowned".equals(var0) && (var5 = EntityTypes.DROWNED.create(var2.getLevel(), EntitySpawnReason.STRUCTURE)) != null) {
                var5.setPersistenceRequired();
                var5.snapTo(var1, 0.0f, 0.0f);
                var5.finalizeSpawn(var2, var2.getCurrentDifficultyAt(var1), EntitySpawnReason.STRUCTURE, null);
                var2.addFreshEntityWithPassengers(var5);
                if (var1.getY() > var2.getSeaLevel()) {
                    var2.setBlock(var1, Blocks.AIR.defaultBlockState(), 2);
                } else {
                    var2.setBlock(var1, Blocks.WATER.defaultBlockState(), 2);
                }
            }
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            int var7 = var0.getHeight(HeightMap.Type.OCEAN_FLOOR_WG, this.templatePosition.getX(), this.templatePosition.getZ());
            this.templatePosition = new BlockPosition(this.templatePosition.getX(), var7, this.templatePosition.getZ());
            BlockPosition var8 = DefinedStructure.transform(new BlockPosition(this.template.getSize().getX() - 1, 0, this.template.getSize().getZ() - 1), EnumBlockMirror.NONE, this.placeSettings.getRotation(), BlockPosition.ZERO).offset(this.templatePosition);
            this.templatePosition = new BlockPosition(this.templatePosition.getX(), this.getHeight(this.templatePosition, var0, var8), this.templatePosition.getZ());
            super.postProcess(var0, var1, var2, var3, var4, var5, var6);
        }

        private int getHeight(BlockPosition var0, IBlockAccess var1, BlockPosition var2) {
            int var3 = var0.getY();
            int var4 = 512;
            int var5 = var3 - 1;
            int var6 = 0;
            for (BlockPosition var8 : BlockPosition.betweenClosed(var0, var2)) {
                int var9 = var8.getX();
                int var10 = var8.getZ();
                int var11 = var0.getY() - 1;
                BlockPosition.MutableBlockPosition var12 = new BlockPosition.MutableBlockPosition(var9, var11, var10);
                IBlockData var13 = var1.getBlockState(var12);
                Fluid var14 = var1.getFluidState(var12);
                while ((var13.isAir() || var14.is(TagsFluid.WATER) || var13.is(TagsBlock.ICE)) && var11 > var1.getMinY() + 1) {
                    var12.set(var9, --var11, var10);
                    var13 = var1.getBlockState(var12);
                    var14 = var1.getFluidState(var12);
                }
                var4 = Math.min(var4, var11);
                if (var11 >= var5 - 2) continue;
                ++var6;
            }
            int var7 = Math.abs(var0.getX() - var2.getX());
            if (var5 - var4 > 2 && var6 > var7 - 2) {
                var3 = var4 + 1;
            }
            return var3;
        }
    }
}

