/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;

public class RuinedPortalStructure
extends Structure {
    private static final String[] STRUCTURE_LOCATION_PORTALS = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] STRUCTURE_LOCATION_GIANT_PORTALS = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private static final float PROBABILITY_OF_GIANT_PORTAL = 0.05f;
    private static final int MIN_Y_INDEX = 15;
    private final List<a> setups;
    public static final MapCodec<RuinedPortalStructure> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group(RuinedPortalStructure.settingsCodec(var02), (App)ExtraCodecs.nonEmptyList(a.CODEC.listOf()).fieldOf("setups").forGetter(var0 -> var0.setups)).apply((Applicative)var02, RuinedPortalStructure::new));

    public RuinedPortalStructure(Structure.c var0, List<a> var1) {
        super(var0);
        this.setups = var1;
    }

    public RuinedPortalStructure(Structure.c var0, a var1) {
        this(var0, List.of(var1));
    }

    @Override
    public Optional<Structure.b> findGenerationPoint(Structure.a var0) {
        RuinedPortalPiece.a var1 = new RuinedPortalPiece.a();
        SeededRandom var2 = var0.random();
        a var3 = null;
        if (this.setups.size() > 1) {
            float var4 = 0.0f;
            for (a a2 : this.setups) {
                var4 += a2.weight();
            }
            float var5 = var2.nextFloat();
            for (a a3 : this.setups) {
                if (!((var5 -= a3.weight() / var4) < 0.0f)) continue;
                var3 = a3;
                break;
            }
        } else {
            var3 = this.setups.get(0);
        }
        if (var3 == null) {
            throw new IllegalStateException();
        }
        a var4 = var3;
        var1.airPocket = RuinedPortalStructure.sample(var2, var4.airPocketProbability());
        var1.mossiness = var4.mossiness();
        var1.overgrown = var4.overgrown();
        var1.vines = var4.vines();
        var1.replaceWithBlackstone = var4.replaceWithBlackstone();
        MinecraftKey var5 = var2.nextFloat() < 0.05f ? MinecraftKey.withDefaultNamespace(STRUCTURE_LOCATION_GIANT_PORTALS[var2.nextInt(STRUCTURE_LOCATION_GIANT_PORTALS.length)]) : MinecraftKey.withDefaultNamespace(STRUCTURE_LOCATION_PORTALS[var2.nextInt(STRUCTURE_LOCATION_PORTALS.length)]);
        DefinedStructure definedStructure = var0.structureTemplateManager().getOrCreate(var5);
        EnumBlockRotation enumBlockRotation = SystemUtils.getRandom(EnumBlockRotation.values(), (RandomSource)var2);
        EnumBlockMirror var8 = var2.nextFloat() < 0.5f ? EnumBlockMirror.NONE : EnumBlockMirror.FRONT_BACK;
        BlockPosition var9 = new BlockPosition(definedStructure.getSize().getX() / 2, 0, definedStructure.getSize().getZ() / 2);
        ChunkGenerator var10 = var0.chunkGenerator();
        LevelHeightAccessor var112 = var0.heightAccessor();
        RandomState var12 = var0.randomState();
        BlockPosition var13 = var0.chunkPos().getWorldPosition();
        StructureBoundingBox var14 = definedStructure.getBoundingBox(var13, enumBlockRotation, var9, var8);
        BlockPosition var15 = var14.getCenter();
        int var16 = var10.getBaseHeight(var15.getX(), var15.getZ(), RuinedPortalPiece.getHeightMapType(var4.placement()), var112, var12) - 1;
        int var17 = RuinedPortalStructure.findSuitableY(var2, var10, var4.placement(), var1.airPocket, var16, var14.getYSpan(), var14, var112, var12);
        BlockPosition var18 = new BlockPosition(var13.getX(), var17, var13.getZ());
        return Optional.of(new Structure.b(var18, var11 -> {
            if (var4.canBeCold()) {
                var1.cold = RuinedPortalStructure.isCold(var18, var0.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock(var18.getX()), QuartPos.fromBlock(var18.getY()), QuartPos.fromBlock(var18.getZ()), var12.sampler()), var10.getSeaLevel());
            }
            var11.addPiece(new RuinedPortalPiece(var0.structureTemplateManager(), var18, var4.placement(), var1, var5, definedStructure, enumBlockRotation, var8, var9));
        }));
    }

    private static boolean sample(SeededRandom var0, float var1) {
        if (var1 == 0.0f) {
            return false;
        }
        if (var1 == 1.0f) {
            return true;
        }
        return var0.nextFloat() < var1;
    }

    private static boolean isCold(BlockPosition var0, Holder<BiomeBase> var1, int var2) {
        return var1.value().coldEnoughToSnow(var0, var2);
    }

    private static int findSuitableY(RandomSource var0, ChunkGenerator var1, RuinedPortalPiece.b var2, boolean var32, int var4, int var5, StructureBoundingBox var6, LevelHeightAccessor var7, RandomState var8) {
        int var14;
        int var10 = var7.getMinY() + 15;
        if (var2 == RuinedPortalPiece.b.IN_NETHER) {
            var9 = var32 ? MathHelper.randomBetweenInclusive(var0, 32, 100) : (var0.nextFloat() < 0.5f ? MathHelper.randomBetweenInclusive(var0, 27, 29) : MathHelper.randomBetweenInclusive(var0, 29, 100));
        } else if (var2 == RuinedPortalPiece.b.IN_MOUNTAIN) {
            var11 = var4 - var5;
            var9 = RuinedPortalStructure.getRandomWithinInterval(var0, 70, var11);
        } else if (var2 == RuinedPortalPiece.b.UNDERGROUND) {
            var11 = var4 - var5;
            var9 = RuinedPortalStructure.getRandomWithinInterval(var0, var10, var11);
        } else {
            var9 = var2 == RuinedPortalPiece.b.PARTLY_BURIED ? var4 - var5 + MathHelper.randomBetweenInclusive(var0, 2, 8) : var4;
        }
        ImmutableList var11 = ImmutableList.of((Object)new BlockPosition(var6.minX(), 0, var6.minZ()), (Object)new BlockPosition(var6.maxX(), 0, var6.minZ()), (Object)new BlockPosition(var6.minX(), 0, var6.maxZ()), (Object)new BlockPosition(var6.maxX(), 0, var6.maxZ()));
        List var12 = var11.stream().map(var3 -> var1.getBaseColumn(var3.getX(), var3.getZ(), var7, var8)).collect(Collectors.toList());
        HeightMap.Type var13 = var2 == RuinedPortalPiece.b.ON_OCEAN_FLOOR ? HeightMap.Type.OCEAN_FLOOR_WG : HeightMap.Type.WORLD_SURFACE_WG;
        block0: for (var14 = var9; var14 > var10; --var14) {
            int var15 = 0;
            for (BlockColumn var17 : var12) {
                IBlockData var18 = var17.getBlock(var14);
                if (!var13.isOpaque().test(var18) || ++var15 != 3) continue;
                break block0;
            }
        }
        return var14;
    }

    private static int getRandomWithinInterval(RandomSource var0, int var1, int var2) {
        if (var1 < var2) {
            return MathHelper.randomBetweenInclusive(var0, var1, var2);
        }
        return var2;
    }

    @Override
    public StructureType<?> type() {
        return StructureType.RUINED_PORTAL;
    }

    public record a(RuinedPortalPiece.b placement, float airPocketProbability, float mossiness, boolean overgrown, boolean vines, boolean canBeCold, boolean replaceWithBlackstone, float weight) {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)RuinedPortalPiece.b.CODEC.fieldOf("placement").forGetter(a::placement), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("air_pocket_probability").forGetter(a::airPocketProbability), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("mossiness").forGetter(a::mossiness), (App)Codec.BOOL.fieldOf("overgrown").forGetter(a::overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(a::vines), (App)Codec.BOOL.fieldOf("can_be_cold").forGetter(a::canBeCold), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(a::replaceWithBlackstone), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("weight").forGetter(a::weight)).apply((Applicative)var0, a::new));
    }
}

