/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.stream.IntStream;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorOctaves;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorPerlin;

public class BlendedNoise
implements DensityFunction.d {
    private static final Codec<Double> SCALE_RANGE = Codec.doubleRange((double)0.001, (double)1000.0);
    private static final MapCodec<BlendedNoise> DATA_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)SCALE_RANGE.fieldOf("xz_scale").forGetter(var0 -> var0.xzScale), (App)SCALE_RANGE.fieldOf("y_scale").forGetter(var0 -> var0.yScale), (App)SCALE_RANGE.fieldOf("xz_factor").forGetter(var0 -> var0.xzFactor), (App)SCALE_RANGE.fieldOf("y_factor").forGetter(var0 -> var0.yFactor), (App)Codec.doubleRange((double)1.0, (double)8.0).fieldOf("smear_scale_multiplier").forGetter(var0 -> var0.smearScaleMultiplier)).apply((Applicative)var02, BlendedNoise::createUnseeded));
    public static final KeyDispatchDataCodec<BlendedNoise> CODEC = KeyDispatchDataCodec.of(DATA_CODEC);
    private final NoiseGeneratorOctaves minLimitNoise;
    private final NoiseGeneratorOctaves maxLimitNoise;
    private final NoiseGeneratorOctaves mainNoise;
    private final double xzMultiplier;
    private final double yMultiplier;
    private final double xzFactor;
    private final double yFactor;
    private final double smearScaleMultiplier;
    private final double maxValue;
    private final double xzScale;
    private final double yScale;

    public static BlendedNoise createUnseeded(double var0, double var2, double var4, double var6, double var8) {
        return new BlendedNoise(new XoroshiroRandomSource(0L), var0, var2, var4, var6, var8);
    }

    private BlendedNoise(NoiseGeneratorOctaves var0, NoiseGeneratorOctaves var1, NoiseGeneratorOctaves var2, double var3, double var5, double var7, double var9, double var11) {
        this.minLimitNoise = var0;
        this.maxLimitNoise = var1;
        this.mainNoise = var2;
        this.xzScale = var3;
        this.yScale = var5;
        this.xzFactor = var7;
        this.yFactor = var9;
        this.smearScaleMultiplier = var11;
        this.xzMultiplier = 684.412 * this.xzScale;
        this.yMultiplier = 684.412 * this.yScale;
        this.maxValue = var0.maxBrokenValue(this.yMultiplier);
    }

    @VisibleForTesting
    public BlendedNoise(RandomSource var0, double var1, double var3, double var5, double var7, double var9) {
        this(NoiseGeneratorOctaves.createLegacyForBlendedNoise(var0, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.createLegacyForBlendedNoise(var0, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.createLegacyForBlendedNoise(var0, IntStream.rangeClosed(-7, 0)), var1, var3, var5, var7, var9);
    }

    public BlendedNoise withNewRandom(RandomSource var0) {
        return new BlendedNoise(var0, this.xzScale, this.yScale, this.xzFactor, this.yFactor, this.smearScaleMultiplier);
    }

    @Override
    public double compute(DensityFunction.b var0) {
        double var1 = (double)var0.blockX() * this.xzMultiplier;
        double var3 = (double)var0.blockY() * this.yMultiplier;
        double var5 = (double)var0.blockZ() * this.xzMultiplier;
        double var7 = var1 / this.xzFactor;
        double var9 = var3 / this.yFactor;
        double var11 = var5 / this.xzFactor;
        double var13 = this.yMultiplier * this.smearScaleMultiplier;
        double var15 = var13 / this.yFactor;
        double var17 = 0.0;
        double var19 = 0.0;
        double var21 = 0.0;
        boolean var23 = true;
        double var24 = 1.0;
        for (int var26 = 0; var26 < 8; ++var26) {
            NoiseGeneratorPerlin var27 = this.mainNoise.getOctaveNoise(var26);
            if (var27 != null) {
                var21 += var27.noise(NoiseGeneratorOctaves.wrap(var7 * var24), NoiseGeneratorOctaves.wrap(var9 * var24), NoiseGeneratorOctaves.wrap(var11 * var24), var15 * var24, var9 * var24) / var24;
            }
            var24 /= 2.0;
        }
        double var26 = (var21 / 10.0 + 1.0) / 2.0;
        boolean var28 = var26 >= 1.0;
        boolean var29 = var26 <= 0.0;
        var24 = 1.0;
        for (int var30 = 0; var30 < 16; ++var30) {
            NoiseGeneratorPerlin var39;
            double var31 = NoiseGeneratorOctaves.wrap(var1 * var24);
            double var33 = NoiseGeneratorOctaves.wrap(var3 * var24);
            double var35 = NoiseGeneratorOctaves.wrap(var5 * var24);
            double var37 = var13 * var24;
            if (!var28 && (var39 = this.minLimitNoise.getOctaveNoise(var30)) != null) {
                var17 += var39.noise(var31, var33, var35, var37, var3 * var24) / var24;
            }
            if (!var29 && (var39 = this.maxLimitNoise.getOctaveNoise(var30)) != null) {
                var19 += var39.noise(var31, var33, var35, var37, var3 * var24) / var24;
            }
            var24 /= 2.0;
        }
        return MathHelper.clampedLerp(var26, var17 / 512.0, var19 / 512.0) / 128.0;
    }

    @Override
    public double minValue() {
        return -this.maxValue();
    }

    @Override
    public double maxValue() {
        return this.maxValue;
    }

    @VisibleForTesting
    public void parityConfigString(StringBuilder var0) {
        var0.append("BlendedNoise{minLimitNoise=");
        this.minLimitNoise.parityConfigString(var0);
        var0.append(", maxLimitNoise=");
        this.maxLimitNoise.parityConfigString(var0);
        var0.append(", mainNoise=");
        this.mainNoise.parityConfigString(var0);
        var0.append(String.format(Locale.ROOT, ", xzScale=%.3f, yScale=%.3f, xzMainScale=%.3f, yMainScale=%.3f, cellWidth=4, cellHeight=8", 684.412, 684.412, 8.555150000000001, 4.277575000000001)).append('}');
    }

    @Override
    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

