/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.synth.NoiseGenerator3Handler;
import org.jspecify.annotations.Nullable;

public class NoiseGenerator3 {
    private final @Nullable NoiseGenerator3Handler[] noiseLevels;
    private final double highestFreqValueFactor;
    private final double highestFreqInputFactor;

    public NoiseGenerator3(RandomSource var0, List<Integer> var1) {
        this(var0, (IntSortedSet)new IntRBTreeSet(var1));
    }

    private NoiseGenerator3(RandomSource var0, IntSortedSet var1) {
        int var3;
        if (var1.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int var2 = -var1.firstInt();
        int var4 = var2 + (var3 = var1.lastInt()) + 1;
        if (var4 < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        NoiseGenerator3Handler var5 = new NoiseGenerator3Handler(var0);
        int var6 = var3;
        this.noiseLevels = new NoiseGenerator3Handler[var4];
        if (var6 >= 0 && var6 < var4 && var1.contains(0)) {
            this.noiseLevels[var6] = var5;
        }
        for (int var7 = var6 + 1; var7 < var4; ++var7) {
            if (var7 >= 0 && var1.contains(var6 - var7)) {
                this.noiseLevels[var7] = new NoiseGenerator3Handler(var0);
                continue;
            }
            var0.consumeCount(262);
        }
        if (var3 > 0) {
            long var7 = (long)(var5.getValue(var5.xo, var5.yo, var5.zo) * 9.223372036854776E18);
            SeededRandom var9 = new SeededRandom(new LegacyRandomSource(var7));
            for (int var10 = var6 - 1; var10 >= 0; --var10) {
                if (var10 < var4 && var1.contains(var6 - var10)) {
                    this.noiseLevels[var10] = new NoiseGenerator3Handler(var9);
                    continue;
                }
                var9.consumeCount(262);
            }
        }
        this.highestFreqInputFactor = Math.pow(2.0, var3);
        this.highestFreqValueFactor = 1.0 / (Math.pow(2.0, var4) - 1.0);
    }

    public double getValue(double var0, double var2, boolean var4) {
        double var5 = 0.0;
        double var7 = this.highestFreqInputFactor;
        double var9 = this.highestFreqValueFactor;
        for (NoiseGenerator3Handler var14 : this.noiseLevels) {
            if (var14 != null) {
                var5 += var14.getValue(var0 * var7 + (var4 ? var14.xo : 0.0), var2 * var7 + (var4 ? var14.yo : 0.0)) * var9;
            }
            var7 /= 2.0;
            var9 *= 2.0;
        }
        return var5;
    }
}

