/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;

public class NoiseGenerator3Handler {
    protected static final int[][] GRADIENT = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}, {1, 1, 0}, {0, -1, 1}, {-1, 1, 0}, {0, -1, -1}};
    private static final double SQRT_3 = Math.sqrt(3.0);
    private static final double F2 = 0.5 * (SQRT_3 - 1.0);
    private static final double G2 = (3.0 - SQRT_3) / 6.0;
    private final int[] p = new int[512];
    public final double xo;
    public final double yo;
    public final double zo;

    public NoiseGenerator3Handler(RandomSource var0) {
        int var1;
        this.xo = var0.nextDouble() * 256.0;
        this.yo = var0.nextDouble() * 256.0;
        this.zo = var0.nextDouble() * 256.0;
        for (var1 = 0; var1 < 256; ++var1) {
            this.p[var1] = var1;
        }
        for (var1 = 0; var1 < 256; ++var1) {
            int var2 = var0.nextInt(256 - var1);
            int var3 = this.p[var1];
            this.p[var1] = this.p[var2 + var1];
            this.p[var2 + var1] = var3;
        }
    }

    private int p(int var0) {
        return this.p[var0 & 0xFF];
    }

    protected static double dot(int[] var0, double var1, double var3, double var5) {
        return (double)var0[0] * var1 + (double)var0[1] * var3 + (double)var0[2] * var5;
    }

    private double getCornerNoise3D(int var0, double var1, double var3, double var5, double var7) {
        double var9;
        double var11 = var7 - var1 * var1 - var3 * var3 - var5 * var5;
        if (var11 < 0.0) {
            var9 = 0.0;
        } else {
            var11 *= var11;
            var9 = var11 * var11 * NoiseGenerator3Handler.dot(GRADIENT[var0], var1, var3, var5);
        }
        return var9;
    }

    public double getValue(double var0, double var2) {
        int var19;
        int var18;
        double var12;
        double var16;
        int var7;
        double var8;
        double var4 = (var0 + var2) * F2;
        int var6 = MathHelper.floor(var0 + var4);
        double var10 = (double)var6 - (var8 = (double)(var6 + (var7 = MathHelper.floor(var2 + var4))) * G2);
        double var14 = var0 - var10;
        if (var14 > (var16 = var2 - (var12 = (double)var7 - var8))) {
            var18 = 1;
            var19 = 0;
        } else {
            var18 = 0;
            var19 = 1;
        }
        double var20 = var14 - (double)var18 + G2;
        double var22 = var16 - (double)var19 + G2;
        double var24 = var14 - 1.0 + 2.0 * G2;
        double var26 = var16 - 1.0 + 2.0 * G2;
        int var28 = var6 & 0xFF;
        int var29 = var7 & 0xFF;
        int var30 = this.p(var28 + this.p(var29)) % 12;
        int var31 = this.p(var28 + var18 + this.p(var29 + var19)) % 12;
        int var32 = this.p(var28 + 1 + this.p(var29 + 1)) % 12;
        double var33 = this.getCornerNoise3D(var30, var14, var16, 0.0, 0.5);
        double var35 = this.getCornerNoise3D(var31, var20, var22, 0.0, 0.5);
        double var37 = this.getCornerNoise3D(var32, var24, var26, 0.0, 0.5);
        return 70.0 * (var33 + var35 + var37);
    }

    public double getValue(double var0, double var2, double var4) {
        int var34;
        int var33;
        int var32;
        int var31;
        int var30;
        int var29;
        double var6 = 0.3333333333333333;
        double var8 = (var0 + var2 + var4) * 0.3333333333333333;
        int var10 = MathHelper.floor(var0 + var8);
        int var11 = MathHelper.floor(var2 + var8);
        int var12 = MathHelper.floor(var4 + var8);
        double var13 = 0.16666666666666666;
        double var15 = (double)(var10 + var11 + var12) * 0.16666666666666666;
        double var17 = (double)var10 - var15;
        double var19 = (double)var11 - var15;
        double var21 = (double)var12 - var15;
        double var23 = var0 - var17;
        double var25 = var2 - var19;
        double var27 = var4 - var21;
        if (var23 >= var25) {
            if (var25 >= var27) {
                var29 = 1;
                var30 = 0;
                var31 = 0;
                var32 = 1;
                var33 = 1;
                var34 = 0;
            } else if (var23 >= var27) {
                var29 = 1;
                var30 = 0;
                var31 = 0;
                var32 = 1;
                var33 = 0;
                var34 = 1;
            } else {
                var29 = 0;
                var30 = 0;
                var31 = 1;
                var32 = 1;
                var33 = 0;
                var34 = 1;
            }
        } else if (var25 < var27) {
            var29 = 0;
            var30 = 0;
            var31 = 1;
            var32 = 0;
            var33 = 1;
            var34 = 1;
        } else if (var23 < var27) {
            var29 = 0;
            var30 = 1;
            var31 = 0;
            var32 = 0;
            var33 = 1;
            var34 = 1;
        } else {
            var29 = 0;
            var30 = 1;
            var31 = 0;
            var32 = 1;
            var33 = 1;
            var34 = 0;
        }
        double var35 = var23 - (double)var29 + 0.16666666666666666;
        double var37 = var25 - (double)var30 + 0.16666666666666666;
        double var39 = var27 - (double)var31 + 0.16666666666666666;
        double var41 = var23 - (double)var32 + 0.3333333333333333;
        double var43 = var25 - (double)var33 + 0.3333333333333333;
        double var45 = var27 - (double)var34 + 0.3333333333333333;
        double var47 = var23 - 1.0 + 0.5;
        double var49 = var25 - 1.0 + 0.5;
        double var51 = var27 - 1.0 + 0.5;
        int var53 = var10 & 0xFF;
        int var54 = var11 & 0xFF;
        int var55 = var12 & 0xFF;
        int var56 = this.p(var53 + this.p(var54 + this.p(var55))) % 12;
        int var57 = this.p(var53 + var29 + this.p(var54 + var30 + this.p(var55 + var31))) % 12;
        int var58 = this.p(var53 + var32 + this.p(var54 + var33 + this.p(var55 + var34))) % 12;
        int var59 = this.p(var53 + 1 + this.p(var54 + 1 + this.p(var55 + 1))) % 12;
        double var60 = this.getCornerNoise3D(var56, var23, var25, var27, 0.6);
        double var62 = this.getCornerNoise3D(var57, var35, var37, var39, 0.6);
        double var64 = this.getCornerNoise3D(var58, var41, var43, var45, 0.6);
        double var66 = this.getCornerNoise3D(var59, var47, var49, var51, 0.6);
        return 32.0 * (var60 + var62 + var64 + var66);
    }
}

