/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.world.level.chunk.NibbleArray;
import org.jspecify.annotations.Nullable;

public abstract class LightEngineStorageArray<M extends LightEngineStorageArray<M>> {
    private static final int CACHE_SIZE = 2;
    private final long[] lastSectionKeys = new long[2];
    private final @Nullable NibbleArray[] lastSections = new NibbleArray[2];
    private boolean cacheEnabled;
    protected final Long2ObjectOpenHashMap<NibbleArray> map;

    protected LightEngineStorageArray(Long2ObjectOpenHashMap<NibbleArray> var0) {
        this.map = var0;
        this.clearCache();
        this.cacheEnabled = true;
    }

    public abstract M copy();

    public NibbleArray copyDataLayer(long var0) {
        NibbleArray var2 = ((NibbleArray)this.map.get(var0)).copy();
        this.map.put(var0, (Object)var2);
        this.clearCache();
        return var2;
    }

    public boolean hasLayer(long var0) {
        return this.map.containsKey(var0);
    }

    public @Nullable NibbleArray getLayer(long var0) {
        NibbleArray var2;
        if (this.cacheEnabled) {
            for (int var22 = 0; var22 < 2; ++var22) {
                if (var0 != this.lastSectionKeys[var22]) continue;
                return this.lastSections[var22];
            }
        }
        if ((var2 = (NibbleArray)this.map.get(var0)) != null) {
            if (this.cacheEnabled) {
                for (int var3 = 1; var3 > 0; --var3) {
                    this.lastSectionKeys[var3] = this.lastSectionKeys[var3 - 1];
                    this.lastSections[var3] = this.lastSections[var3 - 1];
                }
                this.lastSectionKeys[0] = var0;
                this.lastSections[0] = var2;
            }
            return var2;
        }
        return null;
    }

    public @Nullable NibbleArray removeLayer(long var0) {
        return (NibbleArray)this.map.remove(var0);
    }

    public void setLayer(long var0, NibbleArray var2) {
        this.map.put(var0, (Object)var2);
    }

    public void clearCache() {
        for (int var0 = 0; var0 < 2; ++var0) {
            this.lastSectionKeys[var0] = Long.MAX_VALUE;
            this.lastSections[var0] = null;
        }
    }

    public void disableCache() {
        this.cacheEnabled = false;
    }
}

