/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import com.google.common.base.Preconditions;
import net.minecraft.util.ARGB;
import org.jspecify.annotations.Nullable;

public class MaterialMapColor {
    public static final @Nullable MaterialMapColor[] MATERIAL_COLORS = new MaterialMapColor[64];
    public static final MaterialMapColor NONE = new MaterialMapColor(0, 0);
    public static final MaterialMapColor GRASS = new MaterialMapColor(1, 8368696);
    public static final MaterialMapColor SAND = new MaterialMapColor(2, 16247203);
    public static final MaterialMapColor WOOL = new MaterialMapColor(3, 0xC7C7C7);
    public static final MaterialMapColor FIRE = new MaterialMapColor(4, 0xFF0000);
    public static final MaterialMapColor ICE = new MaterialMapColor(5, 0xA0A0FF);
    public static final MaterialMapColor METAL = new MaterialMapColor(6, 0xA7A7A7);
    public static final MaterialMapColor PLANT = new MaterialMapColor(7, 31744);
    public static final MaterialMapColor SNOW = new MaterialMapColor(8, 0xFFFFFF);
    public static final MaterialMapColor CLAY = new MaterialMapColor(9, 10791096);
    public static final MaterialMapColor DIRT = new MaterialMapColor(10, 9923917);
    public static final MaterialMapColor STONE = new MaterialMapColor(11, 0x707070);
    public static final MaterialMapColor WATER = new MaterialMapColor(12, 0x4040FF);
    public static final MaterialMapColor WOOD = new MaterialMapColor(13, 9402184);
    public static final MaterialMapColor QUARTZ = new MaterialMapColor(14, 0xFFFCF5);
    public static final MaterialMapColor COLOR_ORANGE = new MaterialMapColor(15, 14188339);
    public static final MaterialMapColor COLOR_MAGENTA = new MaterialMapColor(16, 11685080);
    public static final MaterialMapColor COLOR_LIGHT_BLUE = new MaterialMapColor(17, 6724056);
    public static final MaterialMapColor COLOR_YELLOW = new MaterialMapColor(18, 0xE5E533);
    public static final MaterialMapColor COLOR_LIGHT_GREEN = new MaterialMapColor(19, 8375321);
    public static final MaterialMapColor COLOR_PINK = new MaterialMapColor(20, 15892389);
    public static final MaterialMapColor COLOR_GRAY = new MaterialMapColor(21, 0x4C4C4C);
    public static final MaterialMapColor COLOR_LIGHT_GRAY = new MaterialMapColor(22, 0x999999);
    public static final MaterialMapColor COLOR_CYAN = new MaterialMapColor(23, 5013401);
    public static final MaterialMapColor COLOR_PURPLE = new MaterialMapColor(24, 8339378);
    public static final MaterialMapColor COLOR_BLUE = new MaterialMapColor(25, 3361970);
    public static final MaterialMapColor COLOR_BROWN = new MaterialMapColor(26, 6704179);
    public static final MaterialMapColor COLOR_GREEN = new MaterialMapColor(27, 6717235);
    public static final MaterialMapColor COLOR_RED = new MaterialMapColor(28, 0x993333);
    public static final MaterialMapColor COLOR_BLACK = new MaterialMapColor(29, 0x191919);
    public static final MaterialMapColor GOLD = new MaterialMapColor(30, 16445005);
    public static final MaterialMapColor DIAMOND = new MaterialMapColor(31, 6085589);
    public static final MaterialMapColor LAPIS = new MaterialMapColor(32, 4882687);
    public static final MaterialMapColor EMERALD = new MaterialMapColor(33, 55610);
    public static final MaterialMapColor PODZOL = new MaterialMapColor(34, 8476209);
    public static final MaterialMapColor NETHER = new MaterialMapColor(35, 0x700200);
    public static final MaterialMapColor TERRACOTTA_WHITE = new MaterialMapColor(36, 13742497);
    public static final MaterialMapColor TERRACOTTA_ORANGE = new MaterialMapColor(37, 10441252);
    public static final MaterialMapColor TERRACOTTA_MAGENTA = new MaterialMapColor(38, 9787244);
    public static final MaterialMapColor TERRACOTTA_LIGHT_BLUE = new MaterialMapColor(39, 7367818);
    public static final MaterialMapColor TERRACOTTA_YELLOW = new MaterialMapColor(40, 12223780);
    public static final MaterialMapColor TERRACOTTA_LIGHT_GREEN = new MaterialMapColor(41, 6780213);
    public static final MaterialMapColor TERRACOTTA_PINK = new MaterialMapColor(42, 10505550);
    public static final MaterialMapColor TERRACOTTA_GRAY = new MaterialMapColor(43, 0x392923);
    public static final MaterialMapColor TERRACOTTA_LIGHT_GRAY = new MaterialMapColor(44, 8874850);
    public static final MaterialMapColor TERRACOTTA_CYAN = new MaterialMapColor(45, 0x575C5C);
    public static final MaterialMapColor TERRACOTTA_PURPLE = new MaterialMapColor(46, 8014168);
    public static final MaterialMapColor TERRACOTTA_BLUE = new MaterialMapColor(47, 4996700);
    public static final MaterialMapColor TERRACOTTA_BROWN = new MaterialMapColor(48, 4993571);
    public static final MaterialMapColor TERRACOTTA_GREEN = new MaterialMapColor(49, 5001770);
    public static final MaterialMapColor TERRACOTTA_RED = new MaterialMapColor(50, 9321518);
    public static final MaterialMapColor TERRACOTTA_BLACK = new MaterialMapColor(51, 2430480);
    public static final MaterialMapColor CRIMSON_NYLIUM = new MaterialMapColor(52, 12398641);
    public static final MaterialMapColor CRIMSON_STEM = new MaterialMapColor(53, 9715553);
    public static final MaterialMapColor CRIMSON_HYPHAE = new MaterialMapColor(54, 6035741);
    public static final MaterialMapColor WARPED_NYLIUM = new MaterialMapColor(55, 1474182);
    public static final MaterialMapColor WARPED_STEM = new MaterialMapColor(56, 3837580);
    public static final MaterialMapColor WARPED_HYPHAE = new MaterialMapColor(57, 5647422);
    public static final MaterialMapColor WARPED_WART_BLOCK = new MaterialMapColor(58, 1356933);
    public static final MaterialMapColor DEEPSLATE = new MaterialMapColor(59, 0x646464);
    public static final MaterialMapColor RAW_IRON = new MaterialMapColor(60, 14200723);
    public static final MaterialMapColor GLOW_LICHEN = new MaterialMapColor(61, 8365974);
    public final int col;
    public final int id;

    private MaterialMapColor(int var0, int var1) {
        if (var0 < 0 || var0 > 63) {
            throw new IndexOutOfBoundsException("Map colour ID must be between 0 and 63 (inclusive)");
        }
        this.id = var0;
        this.col = var1;
        MaterialMapColor.MATERIAL_COLORS[var0] = this;
    }

    public int calculateARGBColor(a var0) {
        if (this == NONE) {
            return 0;
        }
        return ARGB.scaleRGB(ARGB.opaque(this.col), var0.modifier);
    }

    public static MaterialMapColor byId(int var0) {
        Preconditions.checkPositionIndex((int)var0, (int)MATERIAL_COLORS.length, (String)"material id");
        return MaterialMapColor.byIdUnsafe(var0);
    }

    private static MaterialMapColor byIdUnsafe(int var0) {
        MaterialMapColor var1 = MATERIAL_COLORS[var0];
        return var1 != null ? var1 : NONE;
    }

    public static int getColorFromPackedId(int var0) {
        int var1 = var0 & 0xFF;
        return MaterialMapColor.byIdUnsafe(var1 >> 2).calculateARGBColor(a.byIdUnsafe(var1 & 3));
    }

    public byte getPackedId(a var0) {
        return (byte)(this.id << 2 | var0.id & 3);
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a LOW = new a(0, 180);
        public static final /* enum */ a NORMAL = new a(1, 220);
        public static final /* enum */ a HIGH = new a(2, 255);
        public static final /* enum */ a LOWEST = new a(3, 135);
        private static final a[] VALUES;
        public final int id;
        public final int modifier;
        private static final /* synthetic */ a[] h;

        public static a[] values() {
            return (a[])h.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(int var2, int var3) {
            this.id = var2;
            this.modifier = var3;
        }

        public static a byId(int var0) {
            Preconditions.checkPositionIndex((int)var0, (int)VALUES.length, (String)"brightness id");
            return a.byIdUnsafe(var0);
        }

        static a byIdUnsafe(int var0) {
            return VALUES[var0];
        }

        private static /* synthetic */ a[] a() {
            return new a[]{LOW, NORMAL, HIGH, LOWEST};
        }

        static {
            h = a.a();
            VALUES = new a[]{LOW, NORMAL, HIGH, LOWEST};
        }
    }
}

