/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import org.jspecify.annotations.Nullable;

public class PathfinderWater
extends PathfinderAbstract {
    private final boolean allowBreaching;
    private final Long2ObjectMap<PathType> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    public PathfinderWater(boolean var0) {
        this.allowBreaching = var0;
    }

    @Override
    public void prepare(ChunkCache var0, EntityInsentient var1) {
        super.prepare(var0, var1);
        this.pathTypesByPosCache.clear();
    }

    @Override
    public void done() {
        super.done();
        this.pathTypesByPosCache.clear();
    }

    @Override
    public PathPoint getStart() {
        return this.getNode(MathHelper.floor(this.mob.getBoundingBox().minX), MathHelper.floor(this.mob.getBoundingBox().minY + 0.5), MathHelper.floor(this.mob.getBoundingBox().minZ));
    }

    @Override
    public PathDestination getTarget(double var0, double var2, double var4) {
        return this.getTargetNodeAt(var0, var2, var4);
    }

    @Override
    public int getNeighbors(PathPoint[] var0, PathPoint var1) {
        int var2 = 0;
        EnumMap var3 = Maps.newEnumMap(EnumDirection.class);
        for (EnumDirection enumDirection : EnumDirection.values()) {
            PathPoint var8 = this.findAcceptedNode(var1.x + enumDirection.getStepX(), var1.y + enumDirection.getStepY(), var1.z + enumDirection.getStepZ());
            var3.put(enumDirection, var8);
            if (!this.isNodeValid(var8)) continue;
            var0[var2++] = var8;
        }
        for (EnumDirection var5 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            PathPoint pathPoint;
            EnumDirection var6 = var5.getClockWise();
            if (!PathfinderWater.hasMalus((PathPoint)var3.get(var5)) || !PathfinderWater.hasMalus((PathPoint)var3.get(var6)) || !this.isNodeValid(pathPoint = this.findAcceptedNode(var1.x + var5.getStepX() + var6.getStepX(), var1.y, var1.z + var5.getStepZ() + var6.getStepZ()))) continue;
            var0[var2++] = pathPoint;
        }
        return var2;
    }

    protected boolean isNodeValid(@Nullable PathPoint var0) {
        return var0 != null && !var0.closed;
    }

    private static boolean hasMalus(@Nullable PathPoint var0) {
        return var0 != null && var0.costMalus >= 0.0f;
    }

    protected @Nullable PathPoint findAcceptedNode(int var0, int var1, int var2) {
        float var5;
        PathPoint var3 = null;
        PathType var4 = this.getCachedBlockType(var0, var1, var2);
        if ((this.allowBreaching && var4 == PathType.BREACH || var4 == PathType.WATER) && (var5 = this.mob.getPathfindingMalus(var4)) >= 0.0f) {
            var3 = this.getNode(var0, var1, var2);
            var3.type = var4;
            var3.costMalus = Math.max(var3.costMalus, var5);
            if (this.currentContext.level().getFluidState(new BlockPosition(var0, var1, var2)).isEmpty()) {
                var3.costMalus += 8.0f;
            }
        }
        return var3;
    }

    protected PathType getCachedBlockType(int var0, int var1, int var2) {
        return (PathType)((Object)this.pathTypesByPosCache.computeIfAbsent(BlockPosition.asLong(var0, var1, var2), var3 -> this.getPathType(this.currentContext, var0, var1, var2)));
    }

    @Override
    public PathType getPathType(PathfindingContext var0, int var1, int var2, int var3) {
        return this.getPathTypeOfMob(var0, var1, var2, var3, this.mob);
    }

    @Override
    public PathType getPathTypeOfMob(PathfindingContext var0, int var1, int var2, int var3, EntityInsentient var4) {
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        for (int var6 = var1; var6 < var1 + this.entityWidth; ++var6) {
            for (int var7 = var2; var7 < var2 + this.entityHeight; ++var7) {
                for (int var8 = var3; var8 < var3 + this.entityDepth; ++var8) {
                    IBlockData var9 = var0.getBlockState(var5.set(var6, var7, var8));
                    Fluid var10 = var9.getFluidState();
                    if (var10.isEmpty() && var9.isPathfindable(PathMode.WATER) && var9.isAir()) {
                        return PathType.BREACH;
                    }
                    if (var10.is(TagsFluid.WATER)) continue;
                    return PathType.BLOCKED;
                }
            }
        }
        IBlockData var6 = var0.getBlockState(var5);
        if (var6.isPathfindable(PathMode.WATER)) {
            return PathType.WATER;
        }
        return PathType.BLOCKED;
    }
}

