/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class TagValueOutput
implements ValueOutput {
    private final ProblemReporter problemReporter;
    private final DynamicOps<NBTBase> ops;
    private final NBTTagCompound output;

    TagValueOutput(ProblemReporter var0, DynamicOps<NBTBase> var1, NBTTagCompound var2) {
        this.problemReporter = var0;
        this.ops = var1;
        this.output = var2;
    }

    public static TagValueOutput createWithContext(ProblemReporter var0, HolderLookup.a var1) {
        return new TagValueOutput(var0, var1.createSerializationContext(DynamicOpsNBT.INSTANCE), new NBTTagCompound());
    }

    public static TagValueOutput createWithoutContext(ProblemReporter var0) {
        return new TagValueOutput(var0, DynamicOpsNBT.INSTANCE, new NBTTagCompound());
    }

    @Override
    public <T> void store(String var0, Codec<T> var12, T var2) {
        DataResult dataResult = var12.encodeStart(this.ops, var2);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n2)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DataResult.Success var5 = (DataResult.Success)dataResult2;
                this.output.put(var0, (NBTBase)var5.value());
                break;
            }
            case 1: {
                DataResult.Error var6 = (DataResult.Error)dataResult2;
                this.problemReporter.report(new a(var0, var2, var6));
                var6.partialValue().ifPresent(var1 -> this.output.put(var0, (NBTBase)var1));
            }
        }
    }

    @Override
    public <T> void storeNullable(String var0, Codec<T> var1, @Nullable T var2) {
        if (var2 != null) {
            this.store(var0, var1, var2);
        }
    }

    @Override
    public <T> void store(MapCodec<T> var02, T var1) {
        DataResult dataResult = var02.encoder().encodeStart(this.ops, var1);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n2)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DataResult.Success var4 = (DataResult.Success)dataResult2;
                this.output.merge((NBTTagCompound)var4.value());
                break;
            }
            case 1: {
                DataResult.Error var5 = (DataResult.Error)dataResult2;
                this.problemReporter.report(new c(var1, var5));
                var5.partialValue().ifPresent(var0 -> this.output.merge((NBTTagCompound)var0));
            }
        }
    }

    @Override
    public void putBoolean(String var0, boolean var1) {
        this.output.putBoolean(var0, var1);
    }

    @Override
    public void putByte(String var0, byte var1) {
        this.output.putByte(var0, var1);
    }

    @Override
    public void putShort(String var0, short var1) {
        this.output.putShort(var0, var1);
    }

    @Override
    public void putInt(String var0, int var1) {
        this.output.putInt(var0, var1);
    }

    @Override
    public void putLong(String var0, long var1) {
        this.output.putLong(var0, var1);
    }

    @Override
    public void putFloat(String var0, float var1) {
        this.output.putFloat(var0, var1);
    }

    @Override
    public void putDouble(String var0, double var1) {
        this.output.putDouble(var0, var1);
    }

    @Override
    public void putString(String var0, String var1) {
        this.output.putString(var0, var1);
    }

    @Override
    public void putIntArray(String var0, int[] var1) {
        this.output.putIntArray(var0, var1);
    }

    private ProblemReporter reporterForChild(String var0) {
        return this.problemReporter.forChild(new ProblemReporter.c(var0));
    }

    @Override
    public ValueOutput child(String var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        this.output.put(var0, var1);
        return new TagValueOutput(this.reporterForChild(var0), this.ops, var1);
    }

    @Override
    public ValueOutput.b childrenList(String var0) {
        NBTTagList var1 = new NBTTagList();
        this.output.put(var0, var1);
        return new d(var0, this.problemReporter, this.ops, var1);
    }

    @Override
    public <T> ValueOutput.a<T> list(String var0, Codec<T> var1) {
        NBTTagList var2 = new NBTTagList();
        this.output.put(var0, var2);
        return new e<T>(this.problemReporter, var0, this.ops, var1, var2);
    }

    @Override
    public void discard(String var0) {
        this.output.remove(var0);
    }

    @Override
    public boolean isEmpty() {
        return this.output.isEmpty();
    }

    public NBTTagCompound buildResult() {
        return this.output;
    }

    public record a(String name, Object value, DataResult.Error<?> error) implements ProblemReporter.g
    {
        @Override
        public String description() {
            return "Failed to encode value '" + String.valueOf(this.value) + "' to field '" + this.name + "': " + this.error.message();
        }
    }

    public record c(Object value, DataResult.Error<?> error) implements ProblemReporter.g
    {
        @Override
        public String description() {
            return "Failed to merge value '" + String.valueOf(this.value) + "' to an object: " + this.error.message();
        }
    }

    static class d
    implements ValueOutput.b {
        private final String fieldName;
        private final ProblemReporter problemReporter;
        private final DynamicOps<NBTBase> ops;
        private final NBTTagList output;

        d(String var0, ProblemReporter var1, DynamicOps<NBTBase> var2, NBTTagList var3) {
            this.fieldName = var0;
            this.problemReporter = var1;
            this.ops = var2;
            this.output = var3;
        }

        @Override
        public ValueOutput addChild() {
            int var0 = this.output.size();
            NBTTagCompound var1 = new NBTTagCompound();
            this.output.add(var1);
            return new TagValueOutput(this.problemReporter.forChild(new ProblemReporter.d(this.fieldName, var0)), this.ops, var1);
        }

        @Override
        public void discardLast() {
            this.output.removeLast();
        }

        @Override
        public boolean isEmpty() {
            return this.output.isEmpty();
        }
    }

    static class e<T>
    implements ValueOutput.a<T> {
        private final ProblemReporter problemReporter;
        private final String name;
        private final DynamicOps<NBTBase> ops;
        private final Codec<T> codec;
        private final NBTTagList output;

        e(ProblemReporter var0, String var1, DynamicOps<NBTBase> var2, Codec<T> var3, NBTTagList var4) {
            this.problemReporter = var0;
            this.name = var1;
            this.ops = var2;
            this.codec = var3;
            this.output = var4;
        }

        @Override
        public void add(T var0) {
            DataResult dataResult = this.codec.encodeStart(this.ops, var0);
            Objects.requireNonNull(dataResult);
            DataResult dataResult2 = dataResult;
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n2)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    DataResult.Success var3 = (DataResult.Success)dataResult2;
                    this.output.add((NBTBase)var3.value());
                    break;
                }
                case 1: {
                    DataResult.Error var4 = (DataResult.Error)dataResult2;
                    this.problemReporter.report(new b(this.name, var0, var4));
                    var4.partialValue().ifPresent(this.output::add);
                }
            }
        }

        @Override
        public boolean isEmpty() {
            return this.output.isEmpty();
        }
    }

    public record b(String name, Object value, DataResult.Error<?> error) implements ProblemReporter.g
    {
        @Override
        public String description() {
            return "Failed to append value '" + String.valueOf(this.value) + "' to list '" + this.name + "': " + this.error.message();
        }
    }
}

