/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;

public interface WorldData {
    public a getRespawnData();

    public long getGameTime();

    public long getDayTime();

    public boolean isThundering();

    public boolean isRaining();

    public void setRaining(boolean var1);

    public boolean isHardcore();

    public EnumDifficulty getDifficulty();

    public boolean isDifficultyLocked();

    default public void fillCrashReportCategory(CrashReportSystemDetails var0, LevelHeightAccessor var1) {
        var0.setDetail("Level spawn location", () -> CrashReportSystemDetails.formatLocation(var1, this.getRespawnData().pos()));
        var0.setDetail("Level time", () -> String.format(Locale.ROOT, "%d game time, %d day time", this.getGameTime(), this.getDayTime()));
    }

    public record a(GlobalPos globalPos, float yaw, float pitch) {
        public static final a DEFAULT = new a(GlobalPos.of(World.OVERWORLD, BlockPosition.ZERO), 0.0f, 0.0f);
        public static final MapCodec<a> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)GlobalPos.MAP_CODEC.forGetter(a::globalPos), (App)Codec.floatRange((float)-180.0f, (float)180.0f).fieldOf("yaw").forGetter(a::yaw), (App)Codec.floatRange((float)-90.0f, (float)90.0f).fieldOf("pitch").forGetter(a::pitch)).apply((Applicative)var0, a::new));
        public static final Codec<a> CODEC = MAP_CODEC.codec();
        public static final StreamCodec<ByteBuf, a> STREAM_CODEC = StreamCodec.composite(GlobalPos.STREAM_CODEC, a::globalPos, ByteBufCodecs.FLOAT, a::yaw, ByteBufCodecs.FLOAT, a::pitch, a::new);

        public static a of(ResourceKey<World> var0, BlockPosition var1, float var2, float var3) {
            return new a(GlobalPos.of(var0, var1.immutable()), MathHelper.wrapDegrees(var2), MathHelper.clamp(var3, -90.0f, 90.0f));
        }

        public ResourceKey<World> dimension() {
            return this.globalPos.dimension();
        }

        public BlockPosition pos() {
            return this.globalPos.pos();
        }
    }
}

