/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.criterion.CriterionConditionItem;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class FilteredFunction
extends LootItemFunctionConditional {
    public static final MapCodec<FilteredFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> FilteredFunction.commonFields(var02).and(var02.group((App)CriterionConditionItem.CODEC.fieldOf("item_filter").forGetter(var0 -> var0.filter), (App)LootItemFunctions.ROOT_CODEC.optionalFieldOf("on_pass").forGetter(var0 -> var0.onPass), (App)LootItemFunctions.ROOT_CODEC.optionalFieldOf("on_fail").forGetter(var0 -> var0.onFail))).apply((Applicative)var02, FilteredFunction::new));
    private final CriterionConditionItem filter;
    private final Optional<LootItemFunction> onPass;
    private final Optional<LootItemFunction> onFail;

    FilteredFunction(List<LootItemCondition> var0, CriterionConditionItem var1, Optional<LootItemFunction> var2, Optional<LootItemFunction> var3) {
        super(var0);
        this.filter = var1;
        this.onPass = var2;
        this.onFail = var3;
    }

    public LootItemFunctionType<FilteredFunction> getType() {
        return LootItemFunctions.FILTERED;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        Optional<LootItemFunction> var2;
        Optional<LootItemFunction> optional = var2 = this.filter.test(var0) ? this.onPass : this.onFail;
        if (var2.isPresent()) {
            return (ItemStack)var2.get().apply(var0, var1);
        }
        return var0;
    }

    @Override
    public void validate(LootCollector var0) {
        super.validate(var0);
        this.onPass.ifPresent(var1 -> var1.validate(var0.forChild(new ProblemReporter.c("on_pass"))));
        this.onFail.ifPresent(var1 -> var1.validate(var0.forChild(new ProblemReporter.c("on_fail"))));
    }

    public static a filtered(CriterionConditionItem var0) {
        return new a(var0);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final CriterionConditionItem itemPredicate;
        private Optional<LootItemFunction> onPass = Optional.empty();
        private Optional<LootItemFunction> onFail = Optional.empty();

        a(CriterionConditionItem var0) {
            this.itemPredicate = var0;
        }

        @Override
        protected a getThis() {
            return this;
        }

        public a onPass(Optional<LootItemFunction> var0) {
            this.onPass = var0;
            return this;
        }

        public a onFail(Optional<LootItemFunction> var0) {
            this.onFail = var0;
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new FilteredFunction(this.getConditions(), this.itemPredicate, this.onPass, this.onFail);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

