/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import org.slf4j.Logger;

public interface ListOperation {
    public static final MapCodec<ListOperation> UNLIMITED_CODEC = ListOperation.codec(Integer.MAX_VALUE);

    public static MapCodec<ListOperation> codec(int var02) {
        return f.CODEC.dispatchMap("mode", ListOperation::mode, var0 -> var0.mapCodec).validate(var1 -> {
            int var3;
            d var2;
            if (var1 instanceof d && (var2 = (d)var1).size().isPresent() && (var3 = var2.size().get().intValue()) > var02) {
                return DataResult.error(() -> "Size value too large: " + var3 + ", max size is " + var02);
            }
            return DataResult.success((Object)var1);
        });
    }

    public f mode();

    default public <T> List<T> apply(List<T> var0, List<T> var1) {
        return this.apply(var0, var1, Integer.MAX_VALUE);
    }

    public <T> List<T> apply(List<T> var1, List<T> var2, int var3);

    public static final class f
    extends Enum<f>
    implements INamable {
        public static final /* enum */ f REPLACE_ALL = new f("replace_all", c.MAP_CODEC);
        public static final /* enum */ f REPLACE_SECTION = new f("replace_section", d.MAP_CODEC);
        public static final /* enum */ f INSERT = new f("insert", b.MAP_CODEC);
        public static final /* enum */ f APPEND = new f("append", a.MAP_CODEC);
        public static final Codec<f> CODEC;
        private final String id;
        final MapCodec<? extends ListOperation> mapCodec;
        private static final /* synthetic */ f[] h;

        public static f[] values() {
            return (f[])h.clone();
        }

        public static f valueOf(String var0) {
            return Enum.valueOf(f.class, var0);
        }

        private f(String var2, MapCodec var3) {
            this.id = var2;
            this.mapCodec = var3;
        }

        public MapCodec<? extends ListOperation> mapCodec() {
            return this.mapCodec;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        private static /* synthetic */ f[] b() {
            return new f[]{REPLACE_ALL, REPLACE_SECTION, INSERT, APPEND};
        }

        static {
            h = f.b();
            CODEC = INamable.fromEnum(f::values);
        }
    }

    public record d(int offset, Optional<Integer> size) implements ListOperation
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<d> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("offset", (Object)0).forGetter(d::offset), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("size").forGetter(d::size)).apply((Applicative)var0, d::new));

        public d(int var0) {
            this(var0, Optional.empty());
        }

        @Override
        public f mode() {
            return f.REPLACE_SECTION;
        }

        @Override
        public <T> List<T> apply(List<T> var0, List<T> var1, int var2) {
            ImmutableList var6;
            int var3 = var0.size();
            if (this.offset > var3) {
                LOGGER.error("Cannot replace when offset is out of bounds");
                return var0;
            }
            ImmutableList.Builder var4 = ImmutableList.builder();
            var4.addAll(var0.subList(0, this.offset));
            var4.addAll(var1);
            int var5 = this.offset + this.size.orElse(var1.size());
            if (var5 < var3) {
                var4.addAll(var0.subList(var5, var3));
            }
            if ((var6 = var4.build()).size() > var2) {
                LOGGER.error("Contents overflow in section replacement");
                return var0;
            }
            return var6;
        }
    }

    public record e<T>(List<T> value, ListOperation operation) {
        public static <T> Codec<e<T>> codec(Codec<T> var0, int var1) {
            return RecordCodecBuilder.create(var2 -> var2.group((App)var0.sizeLimitedListOf(var1).fieldOf("values").forGetter(var0 -> var0.value), (App)ListOperation.codec(var1).forGetter(var0 -> var0.operation)).apply((Applicative)var2, e::new));
        }

        public List<T> apply(List<T> var0) {
            return this.operation.apply(var0, this.value);
        }
    }

    public static class a
    implements ListOperation {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final a INSTANCE = new a();
        public static final MapCodec<a> MAP_CODEC = MapCodec.unit(() -> INSTANCE);

        private a() {
        }

        @Override
        public f mode() {
            return f.APPEND;
        }

        @Override
        public <T> List<T> apply(List<T> var0, List<T> var1, int var2) {
            if (var0.size() + var1.size() > var2) {
                LOGGER.error("Contents overflow in section append");
                return var0;
            }
            return Stream.concat(var0.stream(), var1.stream()).toList();
        }
    }

    public record b(int offset) implements ListOperation
    {
        private static final Logger LOGGER = LogUtils.getLogger();
        public static final MapCodec<b> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("offset", (Object)0).forGetter(b::offset)).apply((Applicative)var0, b::new));

        @Override
        public f mode() {
            return f.INSERT;
        }

        @Override
        public <T> List<T> apply(List<T> var0, List<T> var1, int var2) {
            int var3 = var0.size();
            if (this.offset > var3) {
                LOGGER.error("Cannot insert when offset is out of bounds");
                return var0;
            }
            if (var3 + var1.size() > var2) {
                LOGGER.error("Contents overflow in section insertion");
                return var0;
            }
            ImmutableList.Builder var4 = ImmutableList.builder();
            var4.addAll(var0.subList(0, this.offset));
            var4.addAll(var1);
            var4.addAll(var0.subList(this.offset, var3));
            return var4.build();
        }
    }

    public static class c
    implements ListOperation {
        public static final c INSTANCE = new c();
        public static final MapCodec<c> MAP_CODEC = MapCodec.unit(() -> INSTANCE);

        private c() {
        }

        @Override
        public f mode() {
            return f.REPLACE_ALL;
        }

        @Override
        public <T> List<T> apply(List<T> var0, List<T> var1, int var2) {
            return var1;
        }
    }
}

