/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.network.Filterable;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetBookCoverFunction
extends LootItemFunctionConditional {
    public static final MapCodec<SetBookCoverFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetBookCoverFunction.commonFields(var02).and(var02.group((App)Filterable.codec(Codec.string((int)0, (int)32)).optionalFieldOf("title").forGetter(var0 -> var0.title), (App)Codec.STRING.optionalFieldOf("author").forGetter(var0 -> var0.author), (App)ExtraCodecs.intRange(0, 3).optionalFieldOf("generation").forGetter(var0 -> var0.generation))).apply((Applicative)var02, SetBookCoverFunction::new));
    private final Optional<String> author;
    private final Optional<Filterable<String>> title;
    private final Optional<Integer> generation;

    public SetBookCoverFunction(List<LootItemCondition> var0, Optional<Filterable<String>> var1, Optional<String> var2, Optional<Integer> var3) {
        super(var0);
        this.author = var2;
        this.title = var1;
        this.generation = var3;
    }

    @Override
    protected ItemStack run(ItemStack var0, LootTableInfo var1) {
        var0.update(DataComponents.WRITTEN_BOOK_CONTENT, WrittenBookContent.EMPTY, this::apply);
        return var0;
    }

    private WrittenBookContent apply(WrittenBookContent var0) {
        return new WrittenBookContent(this.title.orElseGet(var0::title), this.author.orElseGet(var0::author), this.generation.orElseGet(var0::generation), var0.pages(), var0.resolved());
    }

    public LootItemFunctionType<SetBookCoverFunction> getType() {
        return LootItemFunctions.SET_BOOK_COVER;
    }
}

