/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.score.ContextScoreboardNameProvider;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProvider;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProviders;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;

public record ScoreboardValue(ScoreboardNameProvider target, String score, float scale) implements NumberProvider
{
    public static final MapCodec<ScoreboardValue> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ScoreboardNameProviders.CODEC.fieldOf("target").forGetter(ScoreboardValue::target), (App)Codec.STRING.fieldOf("score").forGetter(ScoreboardValue::score), (App)Codec.FLOAT.fieldOf("scale").orElse((Object)Float.valueOf(1.0f)).forGetter(ScoreboardValue::scale)).apply((Applicative)var0, ScoreboardValue::new));

    @Override
    public LootNumberProviderType getType() {
        return NumberProviders.SCORE;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.target.getReferencedContextParams();
    }

    public static ScoreboardValue fromScoreboard(LootTableInfo.EntityTarget var0, String var1) {
        return ScoreboardValue.fromScoreboard(var0, var1, 1.0f);
    }

    public static ScoreboardValue fromScoreboard(LootTableInfo.EntityTarget var0, String var1, float var2) {
        return new ScoreboardValue(ContextScoreboardNameProvider.forTarget(var0), var1, var2);
    }

    @Override
    public float getFloat(LootTableInfo var0) {
        ScoreHolder var1 = this.target.getScoreHolder(var0);
        if (var1 == null) {
            return 0.0f;
        }
        ScoreboardServer var2 = var0.getLevel().getScoreboard();
        ScoreboardObjective var3 = var2.getObjective(this.score);
        if (var3 == null) {
            return 0.0f;
        }
        ReadOnlyScoreInfo var4 = var2.getPlayerScoreInfo(var1, var3);
        if (var4 == null) {
            return 0.0f;
        }
        return (float)var4.value() * this.scale;
    }
}

