/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.validation;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class PathAllowList
implements PathMatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String COMMENT_PREFIX = "#";
    private final List<a> entries;
    private final Map<String, PathMatcher> compiledPaths = new ConcurrentHashMap<String, PathMatcher>();

    public PathAllowList(List<a> var0) {
        this.entries = var0;
    }

    public PathMatcher getForFileSystem(FileSystem var0) {
        return this.compiledPaths.computeIfAbsent(var0.provider().getScheme(), var12 -> {
            List<PathMatcher> var2;
            try {
                var2 = this.entries.stream().map(var1 -> var1.compile(var0)).toList();
            }
            catch (Exception var3) {
                LOGGER.error("Failed to compile file pattern list", (Throwable)var3);
                return var0 -> false;
            }
            return switch (var2.size()) {
                case 0 -> var0 -> false;
                case 1 -> var2.get(0);
                default -> var1 -> {
                    for (PathMatcher var3 : var2) {
                        if (!var3.matches(var1)) continue;
                        return true;
                    }
                    return false;
                };
            };
        });
    }

    @Override
    public boolean matches(Path var0) {
        return this.getForFileSystem(var0.getFileSystem()).matches(var0);
    }

    public static PathAllowList readPlain(BufferedReader var02) {
        return new PathAllowList(var02.lines().flatMap(var0 -> a.parse(var0).stream()).toList());
    }

    public record a(b type, String pattern) {
        public PathMatcher compile(FileSystem var0) {
            return this.type().compile(var0, this.pattern);
        }

        static Optional<a> parse(String var0) {
            if (var0.isBlank() || var0.startsWith(PathAllowList.COMMENT_PREFIX)) {
                return Optional.empty();
            }
            if (!var0.startsWith("[")) {
                return Optional.of(new a(b.PREFIX, var0));
            }
            int var1 = var0.indexOf(93, 1);
            if (var1 == -1) {
                throw new IllegalArgumentException("Unterminated type in line '" + var0 + "'");
            }
            String var2 = var0.substring(1, var1);
            String var3 = var0.substring(var1 + 1);
            return switch (var2) {
                case "glob", "regex" -> Optional.of(new a(b.FILESYSTEM, var2 + ":" + var3));
                case "prefix" -> Optional.of(new a(b.PREFIX, var3));
                default -> throw new IllegalArgumentException("Unsupported definition type in line '" + var0 + "'");
            };
        }

        static a glob(String var0) {
            return new a(b.FILESYSTEM, "glob:" + var0);
        }

        static a regex(String var0) {
            return new a(b.FILESYSTEM, "regex:" + var0);
        }

        static a prefix(String var0) {
            return new a(b.PREFIX, var0);
        }
    }

    @FunctionalInterface
    public static interface b {
        public static final b FILESYSTEM = FileSystem::getPathMatcher;
        public static final b PREFIX = (var0, var12) -> var1 -> var1.toString().startsWith(var12);

        public PathMatcher compile(FileSystem var1, String var2);
    }
}

