/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class AxisAlignedBB {
    private static final double EPSILON = 1.0E-7;
    public final double minX;
    public final double minY;
    public final double minZ;
    public final double maxX;
    public final double maxY;
    public final double maxZ;

    public AxisAlignedBB(double var0, double var2, double var4, double var6, double var8, double var10) {
        this.minX = Math.min(var0, var6);
        this.minY = Math.min(var2, var8);
        this.minZ = Math.min(var4, var10);
        this.maxX = Math.max(var0, var6);
        this.maxY = Math.max(var2, var8);
        this.maxZ = Math.max(var4, var10);
    }

    public AxisAlignedBB(BlockPosition var0) {
        this(var0.getX(), var0.getY(), var0.getZ(), var0.getX() + 1, var0.getY() + 1, var0.getZ() + 1);
    }

    public AxisAlignedBB(Vec3D var0, Vec3D var1) {
        this(var0.x, var0.y, var0.z, var1.x, var1.y, var1.z);
    }

    public static AxisAlignedBB of(StructureBoundingBox var0) {
        return new AxisAlignedBB(var0.minX(), var0.minY(), var0.minZ(), var0.maxX() + 1, var0.maxY() + 1, var0.maxZ() + 1);
    }

    public static AxisAlignedBB unitCubeFromLowerCorner(Vec3D var0) {
        return new AxisAlignedBB(var0.x, var0.y, var0.z, var0.x + 1.0, var0.y + 1.0, var0.z + 1.0);
    }

    public static AxisAlignedBB encapsulatingFullBlocks(BlockPosition var0, BlockPosition var1) {
        return new AxisAlignedBB(Math.min(var0.getX(), var1.getX()), Math.min(var0.getY(), var1.getY()), Math.min(var0.getZ(), var1.getZ()), Math.max(var0.getX(), var1.getX()) + 1, Math.max(var0.getY(), var1.getY()) + 1, Math.max(var0.getZ(), var1.getZ()) + 1);
    }

    public AxisAlignedBB setMinX(double var0) {
        return new AxisAlignedBB(var0, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public AxisAlignedBB setMinY(double var0) {
        return new AxisAlignedBB(this.minX, var0, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public AxisAlignedBB setMinZ(double var0) {
        return new AxisAlignedBB(this.minX, this.minY, var0, this.maxX, this.maxY, this.maxZ);
    }

    public AxisAlignedBB setMaxX(double var0) {
        return new AxisAlignedBB(this.minX, this.minY, this.minZ, var0, this.maxY, this.maxZ);
    }

    public AxisAlignedBB setMaxY(double var0) {
        return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, var0, this.maxZ);
    }

    public AxisAlignedBB setMaxZ(double var0) {
        return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, var0);
    }

    public double min(EnumDirection.EnumAxis var0) {
        return var0.choose(this.minX, this.minY, this.minZ);
    }

    public double max(EnumDirection.EnumAxis var0) {
        return var0.choose(this.maxX, this.maxY, this.maxZ);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof AxisAlignedBB)) {
            return false;
        }
        AxisAlignedBB var1 = (AxisAlignedBB)var0;
        if (Double.compare(var1.minX, this.minX) != 0) {
            return false;
        }
        if (Double.compare(var1.minY, this.minY) != 0) {
            return false;
        }
        if (Double.compare(var1.minZ, this.minZ) != 0) {
            return false;
        }
        if (Double.compare(var1.maxX, this.maxX) != 0) {
            return false;
        }
        if (Double.compare(var1.maxY, this.maxY) != 0) {
            return false;
        }
        return Double.compare(var1.maxZ, this.maxZ) == 0;
    }

    public int hashCode() {
        long var0 = Double.doubleToLongBits(this.minX);
        int var2 = (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.minY);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.minZ);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.maxX);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.maxY);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        var0 = Double.doubleToLongBits(this.maxZ);
        var2 = 31 * var2 + (int)(var0 ^ var0 >>> 32);
        return var2;
    }

    public AxisAlignedBB contract(double var0, double var2, double var4) {
        double var6 = this.minX;
        double var8 = this.minY;
        double var10 = this.minZ;
        double var12 = this.maxX;
        double var14 = this.maxY;
        double var16 = this.maxZ;
        if (var0 < 0.0) {
            var6 -= var0;
        } else if (var0 > 0.0) {
            var12 -= var0;
        }
        if (var2 < 0.0) {
            var8 -= var2;
        } else if (var2 > 0.0) {
            var14 -= var2;
        }
        if (var4 < 0.0) {
            var10 -= var4;
        } else if (var4 > 0.0) {
            var16 -= var4;
        }
        return new AxisAlignedBB(var6, var8, var10, var12, var14, var16);
    }

    public AxisAlignedBB expandTowards(Vec3D var0) {
        return this.expandTowards(var0.x, var0.y, var0.z);
    }

    public AxisAlignedBB expandTowards(double var0, double var2, double var4) {
        double var6 = this.minX;
        double var8 = this.minY;
        double var10 = this.minZ;
        double var12 = this.maxX;
        double var14 = this.maxY;
        double var16 = this.maxZ;
        if (var0 < 0.0) {
            var6 += var0;
        } else if (var0 > 0.0) {
            var12 += var0;
        }
        if (var2 < 0.0) {
            var8 += var2;
        } else if (var2 > 0.0) {
            var14 += var2;
        }
        if (var4 < 0.0) {
            var10 += var4;
        } else if (var4 > 0.0) {
            var16 += var4;
        }
        return new AxisAlignedBB(var6, var8, var10, var12, var14, var16);
    }

    public AxisAlignedBB inflate(double var0, double var2, double var4) {
        double var6 = this.minX - var0;
        double var8 = this.minY - var2;
        double var10 = this.minZ - var4;
        double var12 = this.maxX + var0;
        double var14 = this.maxY + var2;
        double var16 = this.maxZ + var4;
        return new AxisAlignedBB(var6, var8, var10, var12, var14, var16);
    }

    public AxisAlignedBB inflate(double var0) {
        return this.inflate(var0, var0, var0);
    }

    public AxisAlignedBB intersect(AxisAlignedBB var0) {
        double var1 = Math.max(this.minX, var0.minX);
        double var3 = Math.max(this.minY, var0.minY);
        double var5 = Math.max(this.minZ, var0.minZ);
        double var7 = Math.min(this.maxX, var0.maxX);
        double var9 = Math.min(this.maxY, var0.maxY);
        double var11 = Math.min(this.maxZ, var0.maxZ);
        return new AxisAlignedBB(var1, var3, var5, var7, var9, var11);
    }

    public AxisAlignedBB minmax(AxisAlignedBB var0) {
        double var1 = Math.min(this.minX, var0.minX);
        double var3 = Math.min(this.minY, var0.minY);
        double var5 = Math.min(this.minZ, var0.minZ);
        double var7 = Math.max(this.maxX, var0.maxX);
        double var9 = Math.max(this.maxY, var0.maxY);
        double var11 = Math.max(this.maxZ, var0.maxZ);
        return new AxisAlignedBB(var1, var3, var5, var7, var9, var11);
    }

    public AxisAlignedBB move(double var0, double var2, double var4) {
        return new AxisAlignedBB(this.minX + var0, this.minY + var2, this.minZ + var4, this.maxX + var0, this.maxY + var2, this.maxZ + var4);
    }

    public AxisAlignedBB move(BlockPosition var0) {
        return new AxisAlignedBB(this.minX + (double)var0.getX(), this.minY + (double)var0.getY(), this.minZ + (double)var0.getZ(), this.maxX + (double)var0.getX(), this.maxY + (double)var0.getY(), this.maxZ + (double)var0.getZ());
    }

    public AxisAlignedBB move(Vec3D var0) {
        return this.move(var0.x, var0.y, var0.z);
    }

    public AxisAlignedBB move(Vector3f var0) {
        return this.move(var0.x, var0.y, var0.z);
    }

    public boolean intersects(AxisAlignedBB var0) {
        return this.intersects(var0.minX, var0.minY, var0.minZ, var0.maxX, var0.maxY, var0.maxZ);
    }

    public boolean intersects(double var0, double var2, double var4, double var6, double var8, double var10) {
        return this.minX < var6 && this.maxX > var0 && this.minY < var8 && this.maxY > var2 && this.minZ < var10 && this.maxZ > var4;
    }

    public boolean intersects(Vec3D var0, Vec3D var1) {
        return this.intersects(Math.min(var0.x, var1.x), Math.min(var0.y, var1.y), Math.min(var0.z, var1.z), Math.max(var0.x, var1.x), Math.max(var0.y, var1.y), Math.max(var0.z, var1.z));
    }

    public boolean intersects(BlockPosition var0) {
        return this.intersects(var0.getX(), var0.getY(), var0.getZ(), var0.getX() + 1, var0.getY() + 1, var0.getZ() + 1);
    }

    public boolean contains(Vec3D var0) {
        return this.contains(var0.x, var0.y, var0.z);
    }

    public boolean contains(double var0, double var2, double var4) {
        return var0 >= this.minX && var0 < this.maxX && var2 >= this.minY && var2 < this.maxY && var4 >= this.minZ && var4 < this.maxZ;
    }

    public double getSize() {
        double var0 = this.getXsize();
        double var2 = this.getYsize();
        double var4 = this.getZsize();
        return (var0 + var2 + var4) / 3.0;
    }

    public double getXsize() {
        return this.maxX - this.minX;
    }

    public double getYsize() {
        return this.maxY - this.minY;
    }

    public double getZsize() {
        return this.maxZ - this.minZ;
    }

    public AxisAlignedBB deflate(double var0, double var2, double var4) {
        return this.inflate(-var0, -var2, -var4);
    }

    public AxisAlignedBB deflate(double var0) {
        return this.inflate(-var0);
    }

    public Optional<Vec3D> clip(Vec3D var0, Vec3D var1) {
        return AxisAlignedBB.clip(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, var0, var1);
    }

    public static Optional<Vec3D> clip(double var0, double var2, double var4, double var6, double var8, double var10, Vec3D var12, Vec3D var13) {
        double[] var14 = new double[]{1.0};
        double var15 = var13.x - var12.x;
        double var17 = var13.y - var12.y;
        double var19 = var13.z - var12.z;
        EnumDirection var21 = AxisAlignedBB.getDirection(var0, var2, var4, var6, var8, var10, var12, var14, null, var15, var17, var19);
        if (var21 == null) {
            return Optional.empty();
        }
        double var22 = var14[0];
        return Optional.of(var12.add(var22 * var15, var22 * var17, var22 * var19));
    }

    public static @Nullable MovingObjectPositionBlock clip(Iterable<AxisAlignedBB> var0, Vec3D var1, Vec3D var2, BlockPosition var3) {
        double[] var4 = new double[]{1.0};
        EnumDirection var5 = null;
        double var6 = var2.x - var1.x;
        double var8 = var2.y - var1.y;
        double var10 = var2.z - var1.z;
        for (AxisAlignedBB var13 : var0) {
            var5 = AxisAlignedBB.getDirection(var13.move(var3), var1, var4, var5, var6, var8, var10);
        }
        if (var5 == null) {
            return null;
        }
        double var12 = var4[0];
        return new MovingObjectPositionBlock(var1.add(var12 * var6, var12 * var8, var12 * var10), var5, var3, false);
    }

    private static @Nullable EnumDirection getDirection(AxisAlignedBB var0, Vec3D var1, double[] var2, @Nullable EnumDirection var3, double var4, double var6, double var8) {
        return AxisAlignedBB.getDirection(var0.minX, var0.minY, var0.minZ, var0.maxX, var0.maxY, var0.maxZ, var1, var2, var3, var4, var6, var8);
    }

    private static @Nullable EnumDirection getDirection(double var0, double var2, double var4, double var6, double var8, double var10, Vec3D var12, double[] var13, @Nullable EnumDirection var14, double var15, double var17, double var19) {
        if (var15 > 1.0E-7) {
            var14 = AxisAlignedBB.clipPoint(var13, var14, var15, var17, var19, var0, var2, var8, var4, var10, EnumDirection.WEST, var12.x, var12.y, var12.z);
        } else if (var15 < -1.0E-7) {
            var14 = AxisAlignedBB.clipPoint(var13, var14, var15, var17, var19, var6, var2, var8, var4, var10, EnumDirection.EAST, var12.x, var12.y, var12.z);
        }
        if (var17 > 1.0E-7) {
            var14 = AxisAlignedBB.clipPoint(var13, var14, var17, var19, var15, var2, var4, var10, var0, var6, EnumDirection.DOWN, var12.y, var12.z, var12.x);
        } else if (var17 < -1.0E-7) {
            var14 = AxisAlignedBB.clipPoint(var13, var14, var17, var19, var15, var8, var4, var10, var0, var6, EnumDirection.UP, var12.y, var12.z, var12.x);
        }
        if (var19 > 1.0E-7) {
            var14 = AxisAlignedBB.clipPoint(var13, var14, var19, var15, var17, var4, var0, var6, var2, var8, EnumDirection.NORTH, var12.z, var12.x, var12.y);
        } else if (var19 < -1.0E-7) {
            var14 = AxisAlignedBB.clipPoint(var13, var14, var19, var15, var17, var10, var0, var6, var2, var8, EnumDirection.SOUTH, var12.z, var12.x, var12.y);
        }
        return var14;
    }

    private static @Nullable EnumDirection clipPoint(double[] var0, @Nullable EnumDirection var1, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, EnumDirection var18, double var19, double var21, double var23) {
        double var25 = (var8 - var19) / var2;
        double var27 = var21 + var25 * var4;
        double var29 = var23 + var25 * var6;
        if (0.0 < var25 && var25 < var0[0] && var10 - 1.0E-7 < var27 && var27 < var12 + 1.0E-7 && var14 - 1.0E-7 < var29 && var29 < var16 + 1.0E-7) {
            var0[0] = var25;
            return var18;
        }
        return var1;
    }

    public boolean collidedAlongVector(Vec3D var0, List<AxisAlignedBB> var1) {
        Vec3D var2 = this.getCenter();
        Vec3D var3 = var2.add(var0);
        for (AxisAlignedBB var5 : var1) {
            AxisAlignedBB var6 = var5.inflate(this.getXsize() * 0.5 - 1.0E-7, this.getYsize() * 0.5 - 1.0E-7, this.getZsize() * 0.5 - 1.0E-7);
            if (var6.contains(var3) || var6.contains(var2)) {
                return true;
            }
            if (!var6.clip(var2, var3).isPresent()) continue;
            return true;
        }
        return false;
    }

    public double distanceToSqr(Vec3D var0) {
        double var1 = Math.max(Math.max(this.minX - var0.x, var0.x - this.maxX), 0.0);
        double var3 = Math.max(Math.max(this.minY - var0.y, var0.y - this.maxY), 0.0);
        double var5 = Math.max(Math.max(this.minZ - var0.z, var0.z - this.maxZ), 0.0);
        return MathHelper.lengthSquared(var1, var3, var5);
    }

    public double distanceToSqr(AxisAlignedBB var0) {
        double var1 = Math.max(Math.max(this.minX - var0.maxX, var0.minX - this.maxX), 0.0);
        double var3 = Math.max(Math.max(this.minY - var0.maxY, var0.minY - this.maxY), 0.0);
        double var5 = Math.max(Math.max(this.minZ - var0.maxZ, var0.minZ - this.maxZ), 0.0);
        return MathHelper.lengthSquared(var1, var3, var5);
    }

    public String toString() {
        return "AABB[" + this.minX + ", " + this.minY + ", " + this.minZ + "] -> [" + this.maxX + ", " + this.maxY + ", " + this.maxZ + "]";
    }

    public boolean hasNaN() {
        return Double.isNaN(this.minX) || Double.isNaN(this.minY) || Double.isNaN(this.minZ) || Double.isNaN(this.maxX) || Double.isNaN(this.maxY) || Double.isNaN(this.maxZ);
    }

    public Vec3D getCenter() {
        return new Vec3D(MathHelper.lerp(0.5, this.minX, this.maxX), MathHelper.lerp(0.5, this.minY, this.maxY), MathHelper.lerp(0.5, this.minZ, this.maxZ));
    }

    public Vec3D getBottomCenter() {
        return new Vec3D(MathHelper.lerp(0.5, this.minX, this.maxX), this.minY, MathHelper.lerp(0.5, this.minZ, this.maxZ));
    }

    public Vec3D getMinPosition() {
        return new Vec3D(this.minX, this.minY, this.minZ);
    }

    public Vec3D getMaxPosition() {
        return new Vec3D(this.maxX, this.maxY, this.maxZ);
    }

    public static AxisAlignedBB ofSize(Vec3D var0, double var1, double var3, double var5) {
        return new AxisAlignedBB(var0.x - var1 / 2.0, var0.y - var3 / 2.0, var0.z - var5 / 2.0, var0.x + var1 / 2.0, var0.y + var3 / 2.0, var0.z + var5 / 2.0);
    }

    public static class a {
        private float minX = Float.POSITIVE_INFINITY;
        private float minY = Float.POSITIVE_INFINITY;
        private float minZ = Float.POSITIVE_INFINITY;
        private float maxX = Float.NEGATIVE_INFINITY;
        private float maxY = Float.NEGATIVE_INFINITY;
        private float maxZ = Float.NEGATIVE_INFINITY;

        public void include(Vector3fc var0) {
            this.minX = Math.min(this.minX, var0.x());
            this.minY = Math.min(this.minY, var0.y());
            this.minZ = Math.min(this.minZ, var0.z());
            this.maxX = Math.max(this.maxX, var0.x());
            this.maxY = Math.max(this.maxY, var0.y());
            this.maxZ = Math.max(this.maxZ, var0.z());
        }

        public AxisAlignedBB build() {
            return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
    }
}

