/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;

public final class VoxelShapeDiscreteSlice
extends VoxelShapeDiscrete {
    private final VoxelShapeDiscrete parent;
    private final int startX;
    private final int startY;
    private final int startZ;
    private final int endX;
    private final int endY;
    private final int endZ;

    protected VoxelShapeDiscreteSlice(VoxelShapeDiscrete var0, int var1, int var2, int var3, int var4, int var5, int var6) {
        super(var4 - var1, var5 - var2, var6 - var3);
        this.parent = var0;
        this.startX = var1;
        this.startY = var2;
        this.startZ = var3;
        this.endX = var4;
        this.endY = var5;
        this.endZ = var6;
    }

    @Override
    public boolean isFull(int var0, int var1, int var2) {
        return this.parent.isFull(this.startX + var0, this.startY + var1, this.startZ + var2);
    }

    @Override
    public void fill(int var0, int var1, int var2) {
        this.parent.fill(this.startX + var0, this.startY + var1, this.startZ + var2);
    }

    @Override
    public int firstFull(EnumDirection.EnumAxis var0) {
        return this.clampToShape(var0, this.parent.firstFull(var0));
    }

    @Override
    public int lastFull(EnumDirection.EnumAxis var0) {
        return this.clampToShape(var0, this.parent.lastFull(var0));
    }

    private int clampToShape(EnumDirection.EnumAxis var0, int var1) {
        int var2 = var0.choose(this.startX, this.startY, this.startZ);
        int var3 = var0.choose(this.endX, this.endY, this.endZ);
        return MathHelper.clamp(var1, var2, var3) - var2;
    }
}

