/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Hash;
import java.util.List;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.TickListPriority;
import org.jspecify.annotations.Nullable;

public record TickListChunk<T>(T type, BlockPosition pos, int delay, TickListPriority priority) {
    public static final Hash.Strategy<TickListChunk<?>> UNIQUE_TICK_HASH = new Hash.Strategy<TickListChunk<?>>(){

        public int hashCode(TickListChunk<?> var0) {
            return 31 * var0.pos().hashCode() + var0.type().hashCode();
        }

        public boolean equals(@Nullable TickListChunk<?> var0, @Nullable TickListChunk<?> var1) {
            if (var0 == var1) {
                return true;
            }
            if (var0 == null || var1 == null) {
                return false;
            }
            return var0.type() == var1.type() && var0.pos().equals(var1.pos());
        }

        public /* synthetic */ boolean equals(@Nullable Object object, @Nullable Object object2) {
            return this.equals((TickListChunk)object, (TickListChunk)object2);
        }

        public /* synthetic */ int hashCode(Object object) {
            return this.hashCode((TickListChunk)object);
        }
    };

    public static <T> Codec<TickListChunk<T>> codec(Codec<T> var02) {
        MapCodec var1 = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.INT.fieldOf("x").forGetter(BaseBlockPosition::getX), (App)Codec.INT.fieldOf("y").forGetter(BaseBlockPosition::getY), (App)Codec.INT.fieldOf("z").forGetter(BaseBlockPosition::getZ)).apply((Applicative)var0, BlockPosition::new));
        return RecordCodecBuilder.create(var2 -> var2.group((App)var02.fieldOf("i").forGetter(TickListChunk::type), (App)var1.forGetter(TickListChunk::pos), (App)Codec.INT.fieldOf("t").forGetter(TickListChunk::delay), (App)TickListPriority.CODEC.fieldOf("p").forGetter(TickListChunk::priority)).apply((Applicative)var2, TickListChunk::new));
    }

    public static <T> List<TickListChunk<T>> filterTickListForChunk(List<TickListChunk<T>> var0, ChunkCoordIntPair var1) {
        long var22 = var1.toLong();
        return var0.stream().filter(var2 -> ChunkCoordIntPair.asLong(var2.pos()) == var22).toList();
    }

    public NextTickListEntry<T> unpack(long var0, long var2) {
        return new NextTickListEntry<T>(this.type, this.pos, var0 + (long)this.delay, this.priority, var2);
    }

    public static <T> TickListChunk<T> probe(T var0, BlockPosition var1) {
        return new TickListChunk<T>(var0, var1, 0, TickListPriority.NORMAL);
    }
}

