/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.functions;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.functions.PlainTextFunction;
import net.minecraft.commands.functions.StringTemplate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;

public class MacroFunction<T extends ExecutionCommandSource<T>>
implements CommandFunction<T> {
    private static final DecimalFormat DECIMAL_FORMAT = SystemUtils.make(new DecimalFormat("#"), var0 -> {
        var0.setMaximumFractionDigits(15);
        var0.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
    });
    private static final int MAX_CACHE_ENTRIES = 8;
    private final List<String> parameters;
    private final Object2ObjectLinkedOpenHashMap<List<String>, InstantiatedFunction<T>> cache = new Object2ObjectLinkedOpenHashMap(8, 0.25f);
    private final MinecraftKey id;
    private final List<a<T>> entries;

    public MacroFunction(MinecraftKey var0, List<a<T>> var1, List<String> var2) {
        this.id = var0;
        this.entries = var1;
        this.parameters = var2;
    }

    @Override
    public MinecraftKey id() {
        return this.id;
    }

    @Override
    public InstantiatedFunction<T> instantiate(@Nullable NBTTagCompound var0, CommandDispatcher<T> var1) throws FunctionInstantiationException {
        if (var0 == null) {
            throw new FunctionInstantiationException(IChatBaseComponent.translatable("commands.function.error.missing_arguments", IChatBaseComponent.translationArg(this.id())));
        }
        ArrayList<String> var2 = new ArrayList<String>(this.parameters.size());
        for (String string : this.parameters) {
            NBTBase var5 = var0.get(string);
            if (var5 == null) {
                throw new FunctionInstantiationException(IChatBaseComponent.translatable("commands.function.error.missing_argument", IChatBaseComponent.translationArg(this.id()), string));
            }
            var2.add(MacroFunction.stringify(var5));
        }
        InstantiatedFunction var3 = (InstantiatedFunction)this.cache.getAndMoveToLast(var2);
        if (var3 != null) {
            return var3;
        }
        if (this.cache.size() >= 8) {
            this.cache.removeFirst();
        }
        InstantiatedFunction<T> instantiatedFunction = this.substituteAndParse(this.parameters, var2, var1);
        this.cache.put(var2, instantiatedFunction);
        return instantiatedFunction;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String stringify(NBTBase var0) {
        String string;
        NBTBase nBTBase = var0;
        Objects.requireNonNull(nBTBase);
        NBTBase nBTBase2 = nBTBase;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NBTTagFloat.class, NBTTagDouble.class, NBTTagByte.class, NBTTagShort.class, NBTTagLong.class, NBTTagString.class}, (Object)nBTBase2, n2)) {
            case 0: {
                float var4;
                NBTTagFloat nBTTagFloat = (NBTTagFloat)nBTBase2;
                try {
                    float f2;
                    var4 = f2 = nBTTagFloat.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                string = DECIMAL_FORMAT.format(var4);
                return string;
            }
            case 1: {
                double var6;
                NBTTagDouble nBTTagDouble = (NBTTagDouble)nBTBase2;
                {
                    double d2;
                    var6 = d2 = nBTTagDouble.value();
                }
                string = DECIMAL_FORMAT.format(var6);
                return string;
            }
            case 2: {
                byte var9;
                NBTTagByte nBTTagByte = (NBTTagByte)nBTBase2;
                {
                    byte by;
                    var9 = by = nBTTagByte.value();
                }
                string = String.valueOf(var9);
                return string;
            }
            case 3: {
                short var11;
                NBTTagShort nBTTagShort = (NBTTagShort)nBTBase2;
                {
                    short s2;
                    var11 = s2 = nBTTagShort.value();
                }
                string = String.valueOf(var11);
                return string;
            }
            case 4: {
                long var13;
                NBTTagLong nBTTagLong = (NBTTagLong)nBTBase2;
                {
                    long l2;
                    var13 = l2 = nBTTagLong.value();
                }
                string = String.valueOf(var13);
                return string;
            }
            case 5: {
                NBTTagString nBTTagString = (NBTTagString)nBTBase2;
                {
                    String string2;
                    String var16;
                    string = var16 = (string2 = nBTTagString.value());
                    return string;
                }
            }
        }
        string = var0.toString();
        return string;
    }

    private static void lookupValues(List<String> var0, IntList var1, List<String> var22) {
        var22.clear();
        var1.forEach(var2 -> var22.add((String)var0.get(var2)));
    }

    private InstantiatedFunction<T> substituteAndParse(List<String> var0, List<String> var12, CommandDispatcher<T> var2) throws FunctionInstantiationException {
        ArrayList var3 = new ArrayList(this.entries.size());
        ArrayList<String> var4 = new ArrayList<String>(var12.size());
        for (a<T> var6 : this.entries) {
            MacroFunction.lookupValues(var12, var6.parameters(), var4);
            var3.add(var6.instantiate(var4, var2, this.id));
        }
        return new PlainTextFunction(this.id().withPath(var1 -> var1 + "/" + var0.hashCode()), var3);
    }

    static interface a<T> {
        public IntList parameters();

        public UnboundEntryAction<T> instantiate(List<String> var1, CommandDispatcher<T> var2, MinecraftKey var3) throws FunctionInstantiationException;
    }

    static class b<T extends ExecutionCommandSource<T>>
    implements a<T> {
        private final StringTemplate template;
        private final IntList parameters;
        private final T compilationContext;

        public b(StringTemplate var0, IntList var1, T var2) {
            this.template = var0;
            this.parameters = var1;
            this.compilationContext = var2;
        }

        @Override
        public IntList parameters() {
            return this.parameters;
        }

        @Override
        public UnboundEntryAction<T> instantiate(List<String> var0, CommandDispatcher<T> var1, MinecraftKey var2) throws FunctionInstantiationException {
            String var3 = this.template.substitute(var0);
            try {
                return CommandFunction.parseCommand(var1, this.compilationContext, new StringReader(var3));
            }
            catch (CommandSyntaxException var4) {
                throw new FunctionInstantiationException(IChatBaseComponent.translatable("commands.function.error.parse", IChatBaseComponent.translationArg(var2), var3, var4.getMessage()));
            }
        }
    }

    static class c<T>
    implements a<T> {
        private final UnboundEntryAction<T> compiledAction;

        public c(UnboundEntryAction<T> var0) {
            this.compiledAction = var0;
        }

        @Override
        public IntList parameters() {
            return IntLists.emptyList();
        }

        @Override
        public UnboundEntryAction<T> instantiate(List<String> var0, CommandDispatcher<T> var1, MinecraftKey var2) {
            return this.compiledAction;
        }
    }
}

