/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;

public class DispenseBehaviorShears
extends DispenseBehaviorMaybe {
    @Override
    protected ItemStack execute(SourceBlock var02, ItemStack var1) {
        WorldServer var2 = var02.level();
        if (!var2.isClientSide()) {
            BlockPosition var3 = var02.pos().relative(var02.state().getValue(BlockDispenser.FACING));
            this.setSuccess(DispenseBehaviorShears.tryShearBeehive(var2, var1, var3) || DispenseBehaviorShears.tryShearEntity(var2, var3, var1));
            if (this.isSuccess()) {
                var1.hurtAndBreak(1, var2, null, var0 -> {});
            }
        }
        return var1;
    }

    private static boolean tryShearBeehive(WorldServer var02, ItemStack var1, BlockPosition var2) {
        int var4;
        IBlockData var3 = var02.getBlockState(var2);
        if (var3.is(TagsBlock.BEEHIVES, var0 -> var0.hasProperty(BlockBeehive.HONEY_LEVEL) && var0.getBlock() instanceof BlockBeehive) && (var4 = var3.getValue(BlockBeehive.HONEY_LEVEL).intValue()) >= 5) {
            var02.playSound(null, var2, SoundEffects.BEEHIVE_SHEAR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            BlockBeehive.dropHoneycomb(var02, var1, var3, var02.getBlockEntity(var2), null, var2);
            ((BlockBeehive)var3.getBlock()).releaseBeesAndResetHoneyLevel(var02, var3, var2, null, TileEntityBeehive.ReleaseStatus.BEE_RELEASED);
            var02.gameEvent(null, GameEvent.SHEAR, var2);
            return true;
        }
        return false;
    }

    private static boolean tryShearEntity(WorldServer var0, BlockPosition var1, ItemStack var2) {
        List<Entity> var3 = var0.getEntitiesOfClass(Entity.class, new AxisAlignedBB(var1), IEntitySelector.NO_SPECTATORS);
        for (Entity var5 : var3) {
            IShearable var6;
            if (var5.shearOffAllLeashConnections(null)) {
                return true;
            }
            if (!(var5 instanceof IShearable) || !(var6 = (IShearable)((Object)var5)).readyForShearing()) continue;
            var6.shear(var0, SoundCategory.BLOCKS, var2);
            var0.gameEvent(null, GameEvent.SHEAR, var1);
            return true;
        }
        return false;
    }
}

