/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.nbt.NbtAccounterException;

public class NBTReadLimiter {
    private static final int MAX_STACK_DEPTH = 512;
    private final long quota;
    private long usage;
    private final int maxDepth;
    private int depth;

    public NBTReadLimiter(long var0, int var2) {
        this.quota = var0;
        this.maxDepth = var2;
    }

    public static NBTReadLimiter create(long var0) {
        return new NBTReadLimiter(var0, 512);
    }

    public static NBTReadLimiter unlimitedHeap() {
        return new NBTReadLimiter(Long.MAX_VALUE, 512);
    }

    public void accountBytes(long var0, long var2) {
        this.accountBytes(var0 * var2);
    }

    public void accountBytes(long var0) {
        if (var0 < 0L) {
            throw new IllegalArgumentException("Tried to account NBT tag with negative size: " + var0);
        }
        if (this.usage + var0 > this.quota) {
            throw new NbtAccounterException("Tried to read NBT tag that was too big; tried to allocate: " + this.usage + " + " + var0 + " bytes where max allowed: " + this.quota);
        }
        this.usage += var0;
    }

    public void pushDepth() {
        if (this.depth >= this.maxDepth) {
            throw new NbtAccounterException("Tried to read NBT tag with too high complexity, depth > " + this.maxDepth);
        }
        ++this.depth;
    }

    public void popDepth() {
        if (this.depth <= 0) {
            throw new NbtAccounterException("NBT-Accounter tried to pop stack-depth at top-level");
        }
        --this.depth;
    }

    @VisibleForTesting
    public long getUsage() {
        return this.usage;
    }

    @VisibleForTesting
    public int getDepth() {
        return this.depth;
    }
}

