/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public final class NBTTagLongArray
implements NBTList {
    private static final int SELF_SIZE_IN_BYTES = 24;
    public static final NBTTagType<NBTTagLongArray> TYPE = new NBTTagType.b<NBTTagLongArray>(){

        @Override
        public NBTTagLongArray load(DataInput var0, NBTReadLimiter var1) throws IOException {
            return new NBTTagLongArray(1.readAccounted(var0, var1));
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            return var1.visit(1.readAccounted(var0, var2));
        }

        private static long[] readAccounted(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.accountBytes(24L);
            int var2 = var0.readInt();
            var1.accountBytes(8L, var2);
            long[] var3 = new long[var2];
            for (int var4 = 0; var4 < var2; ++var4) {
                var3[var4] = var0.readLong();
            }
            return var3;
        }

        @Override
        public void skip(DataInput var0, NBTReadLimiter var1) throws IOException {
            var0.skipBytes(var0.readInt() * 8);
        }

        @Override
        public String getName() {
            return "LONG[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Long_Array";
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, nBTReadLimiter);
        }
    };
    private long[] data;

    public NBTTagLongArray(long[] var0) {
        this.data = var0;
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeInt(this.data.length);
        for (long var4 : this.data) {
            var0.writeLong(var4);
        }
    }

    @Override
    public int sizeInBytes() {
        return 24 + 8 * this.data.length;
    }

    @Override
    public byte getId() {
        return 12;
    }

    public NBTTagType<NBTTagLongArray> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitLongArray(this);
        return var0.build();
    }

    @Override
    public NBTTagLongArray copy() {
        long[] var0 = new long[this.data.length];
        System.arraycopy(this.data, 0, var0, 0, this.data.length);
        return new NBTTagLongArray(var0);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagLongArray && Arrays.equals(this.data, ((NBTTagLongArray)var0).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitLongArray(this);
    }

    public long[] getAsLongArray() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public NBTTagLong get(int var0) {
        return NBTTagLong.valueOf(this.data[var0]);
    }

    @Override
    public boolean setTag(int var0, NBTBase var1) {
        if (var1 instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)var1;
            this.data[var0] = var2.longValue();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int var0, NBTBase var1) {
        if (var1 instanceof NBTNumber) {
            NBTNumber var2 = (NBTNumber)var1;
            this.data = ArrayUtils.add((long[])this.data, (int)var0, (long)var2.longValue());
            return true;
        }
        return false;
    }

    @Override
    public NBTTagLong remove(int var0) {
        long var1 = this.data[var0];
        this.data = ArrayUtils.remove((long[])this.data, (int)var0);
        return NBTTagLong.valueOf(var1);
    }

    @Override
    public void clear() {
        this.data = new long[0];
    }

    @Override
    public Optional<long[]> asLongArray() {
        return Optional.of(this.data);
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.data);
    }

    @Override
    public /* synthetic */ NBTBase get(int n2) {
        return this.get(n2);
    }

    @Override
    public /* synthetic */ NBTBase remove(int n2) {
        return this.remove(n2);
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

