/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import org.slf4j.Logger;

public class PacketProcessor
implements AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private final Queue<a<?>> packetsToBeHandled = Queues.newConcurrentLinkedQueue();
    private final Thread runningThread;
    private boolean closed;

    public PacketProcessor(Thread var0) {
        this.runningThread = var0;
    }

    public boolean isSameThread() {
        return Thread.currentThread() == this.runningThread;
    }

    public <T extends PacketListener> void scheduleIfPossible(T var0, Packet<T> var1) {
        if (this.closed) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        this.packetsToBeHandled.add(new a<T>(var0, var1));
    }

    public void processQueuedPackets() {
        if (!this.closed) {
            while (!this.packetsToBeHandled.isEmpty()) {
                this.packetsToBeHandled.poll().handle();
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    record a<T extends PacketListener>(T listener, Packet<T> packet) {
        public void handle() {
            if (this.listener.shouldHandleMessage(this.packet)) {
                try {
                    this.packet.handle(this.listener);
                }
                catch (Exception var0) {
                    ReportedException var1;
                    if (var0 instanceof ReportedException && (var1 = (ReportedException)var0).getCause() instanceof OutOfMemoryError) {
                        throw PlayerConnectionUtils.makeReportedException(var0, this.packet, this.listener);
                    }
                    this.listener.onPacketError(this.packet, var0);
                }
            } else {
                LOGGER.debug("Ignoring packet due to disconnection: {}", this.packet);
            }
        }
    }
}

