/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.block.Block;

public class PacketPlayOutBlockAction
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutBlockAction> STREAM_CODEC = Packet.codec(PacketPlayOutBlockAction::write, PacketPlayOutBlockAction::new);
    private final BlockPosition pos;
    private final int b0;
    private final int b1;
    private final Block block;

    public PacketPlayOutBlockAction(BlockPosition var0, Block var1, int var2, int var3) {
        this.pos = var0;
        this.block = var1;
        this.b0 = var2;
        this.b1 = var3;
    }

    private PacketPlayOutBlockAction(RegistryFriendlyByteBuf var0) {
        this.pos = var0.readBlockPos();
        this.b0 = var0.readUnsignedByte();
        this.b1 = var0.readUnsignedByte();
        this.block = (Block)ByteBufCodecs.registry(Registries.BLOCK).decode(var0);
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeBlockPos(this.pos);
        var0.writeByte(this.b0);
        var0.writeByte(this.b1);
        ByteBufCodecs.registry(Registries.BLOCK).encode(var0, this.block);
    }

    @Override
    public PacketType<PacketPlayOutBlockAction> type() {
        return GamePacketTypes.CLIENTBOUND_BLOCK_EVENT;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleBlockEvent(this);
    }

    public BlockPosition getPos() {
        return this.pos;
    }

    public int getB0() {
        return this.b0;
    }

    public int getB1() {
        return this.b1;
    }

    public Block getBlock() {
        return this.block;
    }
}

