/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.status;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.WorldVersion;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.players.NameAndId;

public record ServerPing(IChatBaseComponent description, Optional<ServerPingPlayerSample> players, Optional<ServerData> version, Optional<a> favicon, boolean enforcesSecureChat) {
    public static final Codec<ServerPing> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ComponentSerialization.CODEC.lenientOptionalFieldOf("description", (Object)CommonComponents.EMPTY).forGetter(ServerPing::description), (App)ServerPingPlayerSample.CODEC.lenientOptionalFieldOf("players").forGetter(ServerPing::players), (App)ServerData.CODEC.lenientOptionalFieldOf("version").forGetter(ServerPing::version), (App)a.CODEC.lenientOptionalFieldOf("favicon").forGetter(ServerPing::favicon), (App)Codec.BOOL.lenientOptionalFieldOf("enforcesSecureChat", (Object)false).forGetter(ServerPing::enforcesSecureChat)).apply((Applicative)var0, ServerPing::new));

    public record ServerPingPlayerSample(int max, int online, List<NameAndId> sample) {
        public static final Codec<ServerPingPlayerSample> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.fieldOf("max").forGetter(ServerPingPlayerSample::max), (App)Codec.INT.fieldOf("online").forGetter(ServerPingPlayerSample::online), (App)NameAndId.CODEC.listOf().lenientOptionalFieldOf("sample", List.of()).forGetter(ServerPingPlayerSample::sample)).apply((Applicative)var0, ServerPingPlayerSample::new));
    }

    public record ServerData(String name, int protocol) {
        public static final Codec<ServerData> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.STRING.fieldOf("name").forGetter(ServerData::name), (App)Codec.INT.fieldOf("protocol").forGetter(ServerData::protocol)).apply((Applicative)var0, ServerData::new));

        public static ServerData current() {
            WorldVersion var0 = SharedConstants.getCurrentVersion();
            return new ServerData(var0.name(), var0.protocolVersion());
        }
    }

    public record a(byte[] iconBytes) {
        private static final String PREFIX = "data:image/png;base64,";
        public static final Codec<a> CODEC = Codec.STRING.comapFlatMap(var0 -> {
            if (!var0.startsWith(PREFIX)) {
                return DataResult.error(() -> "Unknown format");
            }
            try {
                String var1 = var0.substring(PREFIX.length()).replaceAll("\n", "");
                byte[] var2 = Base64.getDecoder().decode(var1.getBytes(StandardCharsets.UTF_8));
                return DataResult.success((Object)new a(var2));
            }
            catch (IllegalArgumentException var1) {
                return DataResult.error(() -> "Malformed base64 server icon");
            }
        }, var0 -> PREFIX + new String(Base64.getEncoder().encode(var0.iconBytes), StandardCharsets.UTF_8));
    }
}

